const buttons = [{
//Botón para exportar a Excel
    extend: 'excelHtml5',
    footer: true,
    text: '<span class="badge badge-success"><i class="fas fa-file-excel"></i></span>'
},
//Botón para PDF
{
    extend: 'pdfHtml5',
    download: 'open',
    footer: true,
    text: '<span class="badge  badge-danger"><i class="fas fa-file-pdf"></i></span>',
    exportOptions: {
        columns: [0, ':visible']
    }
},
//Botón para Copiar y Pegar
{
    extend: 'copyHtml5',
    footer: true,
    text: '<span class="badge  badge-primary"><i class="fas fa-copy"></i></span>',
    exportOptions: {
        columns: [0, ':visible']
    }
},
//Botón para Imprimir
{
    extend: 'print',
    footer: true,
    text: '<span class="badge badge-light"><i class="fas fa-print"></i></span>'
},
//Botón para Exportar a formato CSV
{
    extend: 'csvHtml5',
    footer: true,
    text: '<span class="badge  badge-success"><i class="fas fa-file-csv"></i></span>'
},
//Botón para personalizar la vista de columnas
{
    extend: 'colvis',
    text: '<span class="badge  badge-info"><i class="fas fa-columns"></i></span>',
    postfixButtons: ['colvisRestore']
}
];

const language = {
    "lengthMenu": "Mostrar _MENU_ registros",
    "zeroRecords": "No se encontró nada",
    "info": "Mostrando del _START_ al _END_ de un total de _TOTAL_",
    "infoEmpty": "No hay registros",
    "emptyTable": "No hay datos para mostrar",
    "loadingRecords": "Cargando...",
    "processing": "Procesando...",
    "search": "Buscar:",
    "infoFiltered": "(filtrado de un total de _MAX_ registros)",
    "paginate": {
        "first": "Primera",
        "last": "Última",
        "next": "Siguiente",
        "previous": "Anterior"
    },
}
const btnCerrarCaja = document.querySelector('#btnCerrarCaja');
const tipoTicket = document.querySelector('#tipoTicket');
const tipoA4 = document.querySelector('#tipoA4');
document.addEventListener('DOMContentLoaded', function () {
    //Autocomplete - Jquery UI, Buscar Clientes para la Venta
    $("#buscarCliente").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'clientes/buscar',
                dataType: "json",
                data: {
                    q: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('id_cliente').value = ui.item.id;
        }
    })
    verSaldo();

    btnCerrarCaja.addEventListener('click', function () {
        Swal.fire({
            title: 'Esta seguro de cerrar la caja?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si!',
            cancelButtonText: 'No'
        }).then((result) => {
            if (result.isConfirmed) {
                const url = base_url + 'cajas/cerrarCaja';
                const http = new XMLHttpRequest();
                http.open("GET", url, true);
                http.send();
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        }
                    }
                }

            }
        })
    });

    tipoTicket.addEventListener('click', function () {
        tipoReporte('ticket');
    })
    tipoA4.addEventListener('click', function () {
        tipoReporte('a4');
    })
})

// Function para limpiar los input de type date, para mostrar todo los registros
function mostrarTodo(e) {
    document.getElementById('min').value = '';
    document.getElementById('max').value = '';
    if (e.target.name == 'prestamos') {
        t_prest.draw();
    } else if (e.target.name == 'gastos') {
        t_gastos.draw();
    } else if (e.target.name == 'devolucion') {
        t_dev.draw();
    } else if (e.target.name == 'historial_ventas') {
        t_h_v.draw();
    } else if (e.target.name == 'historial_compras') {
        t_h_c.draw();
    } else if (e.target.name == 'historial_cotizacion') {
        t_h_cot.draw();
    } else if (e.target.name == 'vhistorial_creditos') {
        t_cred.draw();
    } else if (e.target.name == 'vhistorial_abonos') {
        t_abonos.draw();
    } else if (e.target.name == 'chistorial_creditos') {
        t_cred_comp.draw();
    } else if (e.target.name == 'chistorial_abonos') {
        t_abonos_compras.draw();
    } else if (e.target.name == 'historial_apartados') {
        t_h_apart.draw();
    } else {
        alertas('Error al cargar la tabla', 'error');
    }
}
//validaciones Solo numeros
function soloNumeros(e) {
    let key = window.Event ? e.which : e.keyCode
    return ((key >= 48 && key <= 57) || (key == 8))
}
// Validacion cantidad de digitos, util para telefono o ruc
function longitud(e, c) {
    if (e.target.value.length >= c) {
        e.target.value = e.target.value.slice(0, c);
        document.getElementById(e.target.name).classList.remove('is-invalid');
    } else {
        document.getElementById(e.target.name).classList.add('is-invalid');
    }
}
// Function de alertas
function alertas(msg, icono) {
    $.smkAlert({
        text: msg.toUpperCase(),
        type: icono,
        position: 'top-right',
        icon: 'glyphicon-time',
        time: 2
    });
}

function alerta_permanent(msg, icono) {
    $.smkAlert({
        text: msg.toUpperCase(),
        type: icono,
        position: 'top-right',
        icon: 'glyphicon-time',
        permanent: true
    });
}

function deleteImg() {
    document.getElementById("icon-cerrar").innerHTML = '';
    document.getElementById("icon-image").classList.remove("d-none");
    document.getElementById("img-preview").src = base_url + 'Assets/img/upload.png';
    document.getElementById("imagen").value = '';
    document.getElementById("foto_actual").value = '';
}
function verificarMonto(e) {
    e.preventDefault();
    const restante = parseFloat(document.getElementById('restante').value);
    const abono = parseFloat(e.target.value);
    if (abono > restante) {
        document.getElementById('btnAbonar').classList.add('d-none');
        document.getElementById('error_monto').textContent = 'Ingresa menor o igual que restante';
        return false;
    } else {
        document.getElementById('btnAbonar').classList.remove('d-none');
        document.getElementById('error_monto').textContent = '';
        return true;
    }
}
function efectivo() {
    if (document.getElementById('total').value == '') {
        document.getElementById('cambio').value = '0.00';
    } else {
        let total = parseFloat(document.getElementById('total').value);
        let efectivo = parseFloat(document.getElementById('efectivo_recibido').value);
        document.getElementById('cambio').value = total - efectivo;
    }
}
function desactivar(e) {
    if (e.target.value == 2) {
        document.getElementById('efectivo_recibido').setAttribute('disabled', 'disabled');
    } else {
        document.getElementById('efectivo_recibido').removeAttribute('disabled');
    }
}

function verSaldo() {
    const url = base_url + 'cajas/grafico_movimiento';
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            const moneda = res.moneda;
            document.getElementById("saldoInicial").textContent = moneda + '  ' + res.datos;
            document.getElementById("saldoCaja").textContent = moneda + '  ' + res.montoCaja;
            document.getElementById("saldoTotal").textContent = moneda + '  ' + res.saldoTotal;
            if (parseFloat(res.saldo) <= 0) {
                btnCerrarCaja.classList.add('d-none');
            }
        }
    }
}

function tipoReporte(nombre) {
    const url = base_url + 'admin/tipoReporte/' + nombre;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            if (res.icono == 'success') {
                alertas(res.msg, res.icono);
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            }
        }
    }
}

function open_link(url)
{
    var link = document.createElement("a");
    link.href = url;
    link.target = "_blank";
    link.click();
}