let t_pro;
let form = document.getElementById('formulario');
let btnEtiqueta = document.getElementById('btnEtiqueta');
let codigo_barra = document.getElementById('codigo_barra');
let cantidad_etiqueta = document.getElementById('cantidad_etiqueta');
let frmEtiqueta = document.getElementById('frmEtiqueta');

let fecha_min = document.getElementById('min');
let fecha_max = document.getElementById('max');
let categoria = document.getElementById('categoria');
let marca = document.getElementById('marca');

let active_row=false;
let active_obj=false;

document.addEventListener('DOMContentLoaded', function () {
    //DataTables Productos - Ajax

    t_pro = $('#t_pro').DataTable({

        "processing": true,
        "serverSide": true,
        "deferRender" : true,
        "sAjaxSource": "" + base_url + 'productos/listar',

        "fnServerParams": function ( aoData ) {
            aoData.push( { "name": "fecha_desde", "value": fecha_min.value},
                         { "name": "fecha_hasta", "value": fecha_max.value},
                         { "name": "categoria", "value": categoria.value},
                         { "name": "marca", "value": marca.value},
                        )
        },
        "type": 'POST',
        "columnDefs": [

            {   
                responsivePriority: 30000, 
                targets: -2, 
            },
            { responsivePriority: 30000, targets: -1 },
        ],
        "drawCallback": function () {
                let api = this.api();
        },

        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "responsive": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "asc"]
        ]
    });

    /*t_pro = $('#t_pro').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + 'productos/listar',
            "dataSrc": ""
        },
        "columns": [
            { "data": "foto" },
            { "data": "codigo" },
            { "data": "codigo_alter" },
            { "data": "descripcion" },
            { "data": "detalles" },                        
            { "data": "precio_venta" },
            { "data": "cantidad" },
            { "data": "categoria" },            
            { "data": "marca" },
            { "data": "estado" },
            { 
                "data": "ultimaventa",
                "render": function ( data, type, row, meta ) {
                    //console.log(row['diasdiferencia'],data)
                    let  arr = data.split("-");
                    if(row['diasdiferencia']<=30){
                        return `<span class='badge badge-success'>${arr[2]}/${arr[1]}/${arr[0]}</span>`;
                    } else if(row['diasdiferencia']<=60) {
                        return `<span class='badge badge-warning'>${arr[2]}/${arr[1]}/${arr[0]}</span>`;
                    } else if(row['diasdiferencia']>60) {
                        return `<span class='badge badge-danger'>${arr[2]}/${arr[1]}/${arr[0]}</span>`;
                    }

                }, },                        
        ],

        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [4, "asc"]
        ]
    });*/

    t_pro.on( 'draw', function () {
        $('#t_pro tbody tr').removeClass('selected');
        activo_buttons(false)
    } );

    $('#t_pro tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
        }
        else {
            t_pro.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
        }
        activo_buttons( t_pro.row( this ).data()  );
    } );

    fecha_min.onchange = function () { t_pro.draw(); }
    fecha_max.onchange = function () { t_pro.draw(); }
    categoria.onchange = function () { t_pro.draw(); }
    marca.onchange = function () { t_pro.draw(); }

    function activo_buttons(obj)
    {
        active_obj=obj;
        //active_row=active_obj.id;
        active_row=obj[11];

        if($('#t_pro tbody tr.selected').length==0)
        {
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();            
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');
            
            if(active_obj.estado_txt==='activo') {
                $('BUTTON.btn-recuperar').hide();
                $('BUTTON.btn-eliminar').show();
            } else {
                $('BUTTON.btn-recuperar').show();
                $('BUTTON.btn-eliminar').hide();
            }            
        }
    }

    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            
            document.getElementById('generales-tab').click();
            
            //console.log( new FormData(this) )

            if (form.checkValidity() === false) {
                event.stopPropagation();
                form.classList.add('was-validated');
            } else {
               
                const url = base_url + 'productos/registrar';
                const formData = new FormData(this);
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(formData);
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#nuevo_producto').modal('hide');
                            t_pro.ajax.reload();
                        }
                    }
                }

            }

        }, false);
    });

    /*btnEtiqueta.addEventListener('click', function () {
        codigo_barra.value = '';
        cantidad_etiqueta.value = '';
        $('#barcode').modal('show');
    });*/

    frmEtiqueta.addEventListener('submit', function (e) {
        e.preventDefault();
        if (codigo_barra.value == '' || cantidad_etiqueta.value == '') {
            alertas('EL BARCODE Y CANTIDAD ES REQUERIDO', 'warning');
        } else {
            $('#barcode').modal('hide');
            this.submit();
        }
    });
    
    //btnEditarPro(1); //quitar linea
})

function limpiar_busqueda()
{
    fecha_min.value = '';
    fecha_max.value = '';
    categoria.value='';
    marca.value='';
    t_pro.search('');
    t_pro.ajax.reload();
}

function frmProducto() {
    document.getElementById('id').value = '';
    document.getElementById('title').textContent = 'Nuevo Producto';
    document.getElementById('btnAccion').textContent = 'Registrar';
    document.getElementById('generales-tab').click();
    deleteImg();  
    form.reset();
    $('#nuevo_producto').modal('show');
}
function preview(e) {
    let input = document.getElementById('imagen');
    let filePath = input.value;
    let extension = /(\.png|\.jpeg|\.jpg)$/i;
    if (!extension.exec(filePath)) {
        alertas('Seleccione un archivo valido', 'warning');
        deleteImg();
        return false;
    } else {
        const url = e.target.files[0];
        const urlTmp = URL.createObjectURL(url);
        document.getElementById("img-preview").src = urlTmp;
        document.getElementById("icon-cerrar").innerHTML = `
        <button class="btn btn-danger" onclick="deleteImg()"><i class="fas fa-times"></i></button>`;
    }
}
function btnFicha(id) {
    window.open( base_url + 'productos/pdfFicha/' + active_obj[1], "_blank");
}


function btnEditarPro(id) {
    deleteImg();
    document.getElementById('title').textContent = 'Modificar Producto';
    document.getElementById('btnAccion').textContent = 'Modificar';
    document.getElementById('generales-tab').click();
    const url = base_url + 'productos/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById('id').value = res.id;
            document.getElementById('codigo').value = res.codigo;
            document.getElementById('codigo_alter').value = res.codigo_alter;
            document.getElementById('codigo_proveedor').value = res.codigo_proveedor;
            document.getElementById('descripcion').value = res.descripcion;
            document.getElementById('detalles').value = res.detalles;

            document.getElementById('tipo').value=(res.tipo!==null)?res.tipo:'';
            document.getElementById('proveedor').value=(res.id_proveedor!==null)?res.id_proveedor:'';
            document.getElementById('medidas').value=(res.id_medida!==null)?res.id_medida:'';
            document.getElementById('categorias').value=(res.id_categoria!==null)?res.id_categoria:'';
            document.getElementById('marcas').value=(res.id_marca!==null)?res.id_marca:'';


            document.getElementById('clasificacion').value = res.clasificacion;
            document.getElementById('ubicacion').value = res.ubicacion;
            document.getElementById('observaciones').value = res.observaciones;

            document.getElementById('precio_compra').value = res.precio_compra;
            document.getElementById('precio_venta').value = res.precio_venta;
            document.getElementById('precio1').value = Number(res.precio1);
            document.getElementById('precio2').value = Number(res.precio2);
            document.getElementById('precio3').value = Number(res.precio3);
            document.getElementById('precio4').value = Number(res.precio4);
            document.getElementById('precio5').value = Number(res.precio5);

            document.getElementById('minimo').value = Number(res.stock_minimo);
            document.getElementById('maximo').value = Number(res.stock_maximo);
            
            document.getElementById('fieldCantidad').innerHTML=(res.cantidad===null)?`Sin cantidad`:Number(res.cantidad);

            document.getElementById('fieldFechaUltimaCompra').innerHTML=(res.costo_ultimo===null)?`Ninguna`:res.fecha_ultimacompra;

            document.getElementById('fieldUltimoCosto').innerHTML=(res.costo_ultimo===null)?`Sin costo`:'Q.'+Number(res.costo_ultimo);
            document.getElementById('fieldCostoPromedio').innerHTML=(res.costo_promedio===null)?`Sin promedio`:'Q.'+Number(res.costo_promedio);

            document.getElementById("estado").checked = (res.estado==1)?true:false;
            document.getElementById("imprime").checked = (res.imprime==1)?true:false;
            //estado imprime


            document.getElementById("img-preview").src = base_url + 'Assets/img/pro/' + res.foto;
            document.getElementById("icon-cerrar").innerHTML = `
            <button class="btn btn-danger" onclick="deleteImg()">
            <i class="fas fa-times"></i></button>`;
            document.getElementById("foto_actual").value = res.foto;
            $('#nuevo_producto').modal('show');
        }

    }
}
function btnVerPro(id) {
    const url = base_url + 'productos/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById('codigo_barra').value = res.codigo;
            document.getElementById('cantidad_etiqueta').focus();
            $('#barcode').modal('show');
        }
    }
}
function btnVerKardex(id) {
    window.open(base_url +'productos/kardex/'+id, "_blank");
}

function btnReporteproductoPDF()
{
    let vars= fecha_min.value+'|'+fecha_max.value+'|'+categoria.value+'|'+marca.value+'|'+t_pro.search();
    vars=window.btoa(encodeURIComponent(vars));
    window.open( base_url +'productos/pdf/'+vars , "_blank");
}

function btnReporteproductoPDFCat()
{
    let vars= fecha_min.value+'|'+fecha_max.value+'|'+categoria.value+'|'+marca.value+'|'+t_pro.search();
    vars=window.btoa(encodeURIComponent(vars));
    window.open( base_url +'productos/pdfCat/'+vars , "_blank");
}


function btnReporteproductoEXCEL()
{
    let vars= fecha_min.value+'|'+fecha_max.value+'|'+categoria.value+'|'+marca.value+'|'+t_pro.search();
    vars=window.btoa(encodeURIComponent(vars));
    window.open( base_url +'productos/excel/'+vars , "_blank");
}

function btnEliminarPro(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El producto no se eliminará de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "productos/eliminar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    t_pro.ajax.reload();
                }
            }
        }
    })
}

function btnReingresarPro(id) {
    Swal.fire({
        title: 'Esta seguro de reingresar?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "productos/reingresar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    t_pro.ajax.reload();
                    alertas(res.msg, res.icono);
                }
            }

        }
    })
}