<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <style>
    h1 {
        font-size: 24px;
    }
    table {
        border-collapse: collapse; /* Essential for removing cell spacing */
        border: none; /* Removes the table's outer border */
    }
    td, th {
        border: none; /* Removes individual cell borders */
        padding: 5px; /* Add some padding for readability */
    }
    DIV.header {
        width:100%;
    }
    DIV.header DIV.header-left {
        background:#001928 !important;
        background:#<?=$data['empresa']['color1']?> !important;
        color:#fff;
        width:124mm;
        float:left;
        margin:0px;
        padding:0px;
        height:16mm;
    }
    DIV.header DIV.header-left P {
        padding-left:5mm;
        padding-top:7mm;
        padding-bottom:1mm;
        margin:0px;
        font-size:5mm;
        font-weight: bold;
    }
    DIV.header DIV.header-right {
        background:#<?=$data['empresa']['color4']?>;
        color:#fff;
        width:40mm;
        height:16mm;
        float:right;
        margin-right:2mm;
    }
    .lateral {
        float:right;
        width:28mm;
        height:90%;
        color:#fff;
        background-image: url("data:image/webp;base64,<?php echo base64_encode(file_get_contents('Assets/img/pdf/lateral.webp')); ?>");
        background-size: 28mm auto;
        background-repeat:no-repeat
    }
    .footer {
        width: 200mm;
        height:24mm;
        background-image: url("data:image/webp;base64,<?php echo base64_encode(file_get_contents('Assets/img/pdf/footer.webp')); ?>");
        background-size: 200mm auto;
        background-repeat:no-repeat;
        text-align: right;
    }

    .footer TABLE TD.pagina {
        
        text-align: center;
        height:21mm;
        width:19mm;
        color:#fff;
        font-weight: bold;
        font-size: 3mm;
    }
    .footer TABLE TD.direccion {
        padding-left:75mm;
        padding-right:4mm;        
        width:180mm;
        color:#fff;
    }

    .celda {
        width:83mm;
        height:55mm;
        border-right:1px solid #000;
        border-bottom:1px solid #000;
        vertical-align: top;
        text-align: center;
        padding:0px;
        margin:0px;
    }
    .celdaIMG {
        width:40mm;
        height:40mm;

        margin-top:2.6mm;
        margin-bottom:2.6mm;
    }    
    .celdaTitulo {
        font-size: 2.8mm;
        line-height:  3.0mm;
        color: #000;
        padding: 5px;
        text-align: left;
        width:70%;
    }
    .celdaCodigo {
        font-weight: bold;
        font-size: 3.5mm;
        color:#fff;
        width:30%;
        text-align: right;
        border-top:1px solid #000;
        border-left:1px solid #000;
        background-color: #<?=$data['empresa']['color3']?>;
    }
    .celdaCodigoSMALL {
        font-size: 2.5mm;
        font-weight: normal;        
    }    
    </style>
</head>

<body>

    <div style='width:166mm;'>

        <?php
            if(!isset($data['productos']) || empty($data['productos'])) {
                echo "<br><br><br><br><h3 style='color:#ff0000;text-align:center;'>No hay productos disponibles</h3>";
            } else {

                $contador = 0;



                foreach ($data['productos'] as $producto) {
                    if ($contador ==0) {
                        echo "<table style='width:100%;'>";
                    }
                    if(($contador%2)==0)
                    {
                        echo "<tr>";
                        echo "<td class='celda'>";
                        echo "<img src='data:image/webp;base64,".base64_encode(file_get_contents('Assets/img/pro/webp/'.$producto['foto']))."' class='celdaIMG'/>";
                        echo "<table style='width:100%;vertical-align:top;'><tr><td class='celdaTitulo'>{$producto['descripcion']}</td><td class='celdaCodigo'>{$producto['codigo']}<br><small class='celdaCodigoSMALL'>&nbsp;{$producto['codigo_alter']}</small></td></table>";
                        echo "</td>";
                    } else {
                        echo "<td class='celda'>";
                        echo "<img src='data:image/webp;base64,".base64_encode(file_get_contents('Assets/img/pro/webp/'.$producto['foto']))."' class='celdaIMG'/>";
                        echo "<table style='width:100%;vertical-align:top;'><tr><td class='celdaTitulo'>{$producto['descripcion']}</td><td class='celdaCodigo'>{$producto['codigo']}<br><small class='celdaCodigoSMALL'>&nbsp;{$producto['codigo_alter']}</small></td></table>";
                        echo "</td>";
                        echo "</tr>";
                    }

                    if ($contador == 7 && $contador > 0) {
                        if(($contador%2)==0) echo "</tr>";
                        echo "</table>";
                        echo "<pagebreak />";
                        $contador = 0;
                    } else {
                        $contador++;
                    }

                }
                if ($contador >0 && $contador < 8) {
                    echo "</table>";
                }

            }
        ?>
                   

    </div>

</body>
</html>