let t_cheq;
const form = document.getElementById('formulario');
const id_cliente = document.getElementById('id');
const title = document.getElementById('title');
const btnAccion = document.getElementById('btnAccion');

const nombre = document.getElementById('nombre');
const telefono = document.getElementById('telefono');
const mensajeria = document.getElementById('mensajeria');
const tipoid = document.getElementById('tipoid');
const nit = document.getElementById('nit');

const formProgramacion = document.getElementById('formularioProgramacion');
const fechaProgramacion = document.getElementById('fecha_programacion');
const IDProgramacion = document.getElementById('id_cliente_programacion');
const ROWProgramacion = document.getElementById('row_cliente_programacion');

const direccion = document.getElementById('direccion');
const municipio = document.getElementById('municipio');
const departamento = document.getElementById('departamento');
const pais = document.getElementById('pais');
const coordenadas = document.getElementById('coordenadas');
const coord_ultimavisita = document.getElementById('coord_ultimavisita');

const contacto = document.getElementById('contacto');
const telcontacto = document.getElementById('telcontacto');
const observaciones = document.getElementById('observaciones');

const limite_credito = document.getElementById('limite_credito');
const dias_credito = document.getElementById('dias_credito');
const id_vendedor1 = document.getElementById('id_vendedor1');
const tipocliente = document.getElementById('tipocliente');

const formAnotaciones = document.getElementById('formularioAnotaciones');
const id_cliente_anotaciones = document.getElementById('id_cliente_anotaciones');
const observaciones_anotaciones = document.getElementById('observaciones_anotaciones');
const nombre_reporte_modal = document.getElementById('nombre_reporte_modal');
const year_pagos = document.getElementById('yearPagos');
const year_ventas = document.getElementById('yearVentas');

const reporte_ventas_table = document.getElementById('reporteventastable');
const reporte_pagos_table = document.getElementById('reportepagostable');


let ventasChartObj=false;
let ventasChartCanvas=false;
let pagosChartObj=false;
let pagosChartCanvas=false;

let active_row=false;
let active_obj=false;
let active_meta=false;

let option=null;


var fecha_prog = $('#fecha_programacion_box').datepicker().on('changeDate', function(ev) { 
    fecha_prog.hide();
  }).data('datepicker');


document.addEventListener('DOMContentLoaded', function(){

    //DataTables Cheques - Ajax
    t_cheq = $('#t_cheq').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + "cheques2/listar",
            "dataSrc": ""
        },
        "columns": [
            {"data": "id"},
            {"data": "ch_cli_cod"},
            {"data": "ch_nombre"},
            {
                "data": "ch_fecha",
                "render": function ( data, type, row, meta ) {
                    let  arr = data.split("-");
                    if(row['diasdiferencia']<=30){
                        return `<span class='badge badge-success'>${arr[2]}/${arr[1]}/${arr[0]}</span>`;
                    } else if(row['diasdiferencia']<=60) {
                        return `<span class='badge badge-warning'>${arr[2]}/${arr[1]}/${arr[0]}</span>`;
                    } else if(row['diasdiferencia']>60) {
                        return `<span class='badge badge-danger'>${arr[2]}/${arr[1]}/${arr[0]}</span>`;
                    }
                },
            },
            {"data": "ch_numero"},            
            {"data": "ch_valor"},            
            {"data": "ch_banco"},                        
            {
                "data": "ch_tipo",
                "render": function ( data, type, row, meta ) {
                    //console.log(data);
                    if(row['ch_tipo'] == "POSTFECHADO"){
                        return `<span class='badge badge-warning'>POST - FECHADO</span>`;
                    } else  {
                        return `<span class='badge badge-danger'>RECHAZADO</span>`;
                    }
                },
            },                                    
            {"data": "ch_id_vendedor"},                                    
            {"data": "ch_ruta"},                                                            
        ],

        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "asc"]
        ]
    });

    t_cheq.on( 'draw', function () {
        $('#t_cheq tbody tr').removeClass('selected');
        activo_buttons(false)
        //frmCliente()
        //btnEditarCli(15)
    } );

    $('#t_cheq tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
            active_meta=false;
        }
        else {
            t_cheq.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
            active_meta=t_cheq.row( this ).index();
        }
        
        activo_buttons( t_cheq.row( this ).data()  );
    } );

    function activo_buttons(obj)
    {
        if(active_obj === undefined) { return }
        active_obj=obj;
        active_row=active_obj.id;

        if($('#t_cheq tbody tr.selected').length==0)
        {
            active_row=false;
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();            
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');
            
            if(active_obj.estado_txt==='activo') {
                $('BUTTON.btn-recuperar').hide();
                $('BUTTON.btn-eliminar').show();
            } else {
                $('BUTTON.btn-recuperar').show();
                $('BUTTON.btn-eliminar').hide();
            }            
        }
    }

    var forms = document.getElementsByClassName('needs-validation');
    // Loop over them and prevent submission
    var validation = Array.prototype.filter.call(forms, function (form) {
        form.addEventListener('submit', function (event) {
            event.preventDefault();

            if (form.checkValidity() === false) {
                event.stopPropagation();
                form.classList.add('was-validated');
                $('#nuevo_cliente li a#'+$('FORM.needs-validation INPUT:invalid').first().parents('DIV.tab-pane').prop('id')+'-tab').tab('show')
            } else {
                const url = base_url + 'cheques/registrar';
                const http = new XMLHttpRequest();
                http.open("POST", url, true);
                http.send(new FormData(this));
                http.onreadystatechange = function () {
                    if (this.readyState == 4 && this.status == 200) {
                        const res = JSON.parse(this.responseText);
                        alertas(res.msg, res.icono);
                        if (res.icono == 'success') {
                            $('#nuevo_cliente').modal('hide');
                            t_cheq.ajax.reload();
                        }
                    }
                }
            }

        }, false);
    });

    formAnotaciones.addEventListener('submit', function (event) {
        event.preventDefault();

        const url = base_url + 'clientes/editarAnotaciones';
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(this));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {
                    $('#modal_anotaciones').modal('hide');
                    //t_cheq.ajax.reload();
                }
            }
        }

    }, false);

    formProgramacion.addEventListener('submit', function (event) {
        event.preventDefault();

        const url = base_url + 'cheques/editarProgramacion';
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(this));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                if (res.icono == 'success') {

                    const drow = t_cheq.row( ROWProgramacion.value );
                    const rowData = drow.data();
                    rowData.programacion=fechaProgramacion.value
                    drow.data(rowData).draw();

                    $('#modal_programacion').modal('hide');
                }
            }
        }

    }, false);


})

function frmCliente() {
    id_cliente.value = '';
    title.textContent = 'Nuevo Cliente';
    btnAccion.textContent = 'Registrar';
    form.classList.remove('was-validated');    
    form.reset();

    const url = base_url + 'cheques/insertar';
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();

    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            pais.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione país";
            option.value = '';
            pais.add(option);

            res.paises.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['pais'];
                option.value = element['cod'];
                pais.add(option);
            });            

            id_vendedor1.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione vendedor";
            option.value = '';
            id_vendedor1.add(option);

            res.vendedores.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['nombre'];
                option.value = element['codven'];
                id_vendedor1.add(option);
            }); 

            pais.value = 'GT';
            id_vendedor1.value = '';

            $('#nuevo_cliente').modal('show');
            $('#nuevo_cliente li a#generales-tab').tab('show')
        }
    }


}

let newtab;

function btnWhatsappCli(id)
{
    if(id===false) return;

    let mensajeria=t_cheq.rows('.selected').data();
    const filteredStr = mensajeria[0].mensajeria.replace(/\D/g, '');
    if(filteredStr.length==8)
    {
        newTab = window.open('https://api.whatsapp.com/send?phone=502'+filteredStr, "myNewWindow", "width=500,height=500");
        setTimeout(() => { 
            newTab.window.close();
        }, 1000);
    } else {
        alertas('No tiene definido un número de mensajería válido', 'danger');
    }
   
}

function btnReporteEstadoCuenta(id)
{
    window.open(base_url +'clientes/generarReporteEstadoCuenta/'+id, "_blank");
}

function btnReporteAntiguedadSaldos(id)
{
    if(id===false) id=0
    window.open(base_url +'clientes/generarReporteAntiguedadSaldos/'+id, "_blank");
}

function btnReporteCuentasxCobrar(id)
{
    if(id===false) id=0
    window.open(base_url +'clientes/generarReporteCuentasCobrar/'+id, "_blank");
}

function btnReporteCli(id)
{
    if(id===false) return
    window.open(base_url +'clientes/dashboard/'+id, "_blank");

    /*const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            nombre_reporte_modal.innerHTML=res.nombre;
            id_cliente.value = res.id;

            $('#reporte_cliente').modal('show');
            actualizarGraficoVentasMesCliente();
            actualizarGraficoPagosMesCliente();

        }
    }*/
}

function actualizarGraficoPagosMesCliente() {
    const anio = year_pagos.value;
    const idcliente = id_cliente.value;
    
    if(pagosChartObj) { pagosChartObj.destroy(); }

    pagosChartCanvas = $('#comparacionPagos').get(0).getContext('2d') 
    const url = base_url + 'clientes/comparacionPagosMes/' + anio +'/'+ idcliente;    

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            var salesChartData = {
                labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                datasets: [
                  {
                    label: 'Pagos',
                    backgroundColor: 'rgba(247,222,97,0.9)',
                    borderColor: 'rgba(247,222,97,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(247,222,97,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(247,222,97,1)',
                    data: [res.pagos.ene, res.pagos.feb, res.pagos.mar, res.pagos.abr, res.pagos.may, res.pagos.jun, res.pagos.jul, res.pagos.ago, res.pagos.sep, res.pagos.oct, res.pagos.nov, res.pagos.dic],
                  }
                ]
              }
            
              var salesChartOptions = {
                maintainAspectRatio: false,
                responsive: true,
                legend: {
                  display: false
                },
                scales: {
                  xAxes: [{
                    gridLines: {
                      display: false
                    }
                  }],
                  yAxes: [{
                    gridLines: {
                      display: false
                    }
                  }]
                }
              }
            
              // This will get the first returned node in the jQuery collection.
              // eslint-disable-next-line no-unused-vars
              pagosChartObj = new Chart(pagosChartCanvas, {
                type: 'bar',
                data: salesChartData,
                options: salesChartOptions
              }
              )

              let total_anual=sumObj(res.pagos);

              reporte_pagos_table.innerHTML=`
              <tr><th scope="row">Enero</th><td class='text-right'>Q.${numFormat(res.pagos.ene)}</td></tr>
              <tr><th scope="row">Febrero</th><td class='text-right'>Q.${numFormat(res.pagos.feb)}</td></tr>
              <tr><th scope="row">Marzo</th><td class='text-right'>Q.${numFormat(res.pagos.mar)}</td></tr>
              <tr><th scope="row">Abril</th><td class='text-right'>Q.${numFormat(res.pagos.abr)}</td></tr>
              <tr><th scope="row">Mayo</th><td class='text-right'>Q.${numFormat(res.pagos.may)}</td></tr>
              <tr><th scope="row">Junio</th><td class='text-right'>Q.${numFormat(res.pagos.jun)}</td></tr>
              <tr><th scope="row">Julio</th><td class='text-right'>Q.${numFormat(res.pagos.jul)}</td></tr>
              <tr><th scope="row">Agosto</th><td class='text-right'>Q.${numFormat(res.pagos.ago)}</td></tr>
              <tr><th scope="row">Septiembre</th><td class='text-right'>Q.${numFormat(res.pagos.sep)}</td></tr>
              <tr><th scope="row">Octubre</th><td class='text-right'>Q.${numFormat(res.pagos.oct)}</td></tr>
              <tr><th scope="row">Noviembre</th><td class='text-right'>Q.${numFormat(res.pagos.nov)}</td></tr>
              <tr><th scope="row">Diciembre</th><td class='text-right'>Q.${numFormat(res.pagos.dic)}</td></tr>
              <tr><th scope="row" class='text-warning'>TOTAL</th><td class='text-right'>Q.${numFormat(total_anual)}</td></tr>
              `
        }
    }

}

function actualizarGraficoVentasMesCliente() {
    const anio = year_ventas.value;
    const idcliente = id_cliente.value;

    if(ventasChartObj) { ventasChartObj.destroy(); }

    ventasChartCanvas = $('#comparacionVentas').get(0).getContext('2d') 

    const url = base_url + 'clientes/comparacionVentasMes/' + anio +'/'+ idcliente;

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            var salesChartData = {
                labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                datasets: [
                  {
                    label: 'Ventas',
                    backgroundColor: 'rgba(247,222,97,0.9)',
                    borderColor: 'rgba(247,222,97,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(247,222,97,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(247,222,97,1)',
                    data: [res.ventas.ene, res.ventas.feb, res.ventas.mar, res.ventas.abr, res.ventas.may, res.ventas.jun, res.ventas.jul, res.ventas.ago, res.ventas.sep, res.ventas.oct, res.ventas.nov, res.ventas.dic],
                  }
                ]
              }
            
              var salesChartOptions = {
                maintainAspectRatio: false,
                responsive: true,
                legend: {
                  display: false
                },
                scales: {
                  xAxes: [{
                    gridLines: {
                      display: false
                    }
                  }],
                  yAxes: [{
                    gridLines: {
                      display: false
                    }
                  }]
                }
              }
            
              // This will get the first returned node in the jQuery collection.
              // eslint-disable-next-line no-unused-vars
              ventasChartObj = new Chart(ventasChartCanvas, {
                type: 'bar',
                data: salesChartData,
                options: salesChartOptions
              }
              )

              let total_anual=sumObj(res.ventas);

              reporte_ventas_table.innerHTML=`
              <tr><th scope="row">Enero</th><td class='text-right'>Q.${numFormat(res.ventas.ene)}</td></tr>
              <tr><th scope="row">Febrero</th><td class='text-right'>Q.${numFormat(res.ventas.feb)}</td></tr>
              <tr><th scope="row">Marzo</th><td class='text-right'>Q.${numFormat(res.ventas.mar)}</td></tr>
              <tr><th scope="row">Abril</th><td class='text-right'>Q.${numFormat(res.ventas.abr)}</td></tr>
              <tr><th scope="row">Mayo</th><td class='text-right'>Q.${numFormat(res.ventas.may)}</td></tr>
              <tr><th scope="row">Junio</th><td class='text-right'>Q.${numFormat(res.ventas.jun)}</td></tr>
              <tr><th scope="row">Julio</th><td class='text-right'>Q.${numFormat(res.ventas.jul)}</td></tr>
              <tr><th scope="row">Agosto</th><td class='text-right'>Q.${numFormat(res.ventas.ago)}</td></tr>
              <tr><th scope="row">Septiembre</th><td class='text-right'>Q.${numFormat(res.ventas.sep)}</td></tr>
              <tr><th scope="row">Octubre</th><td class='text-right'>Q.${numFormat(res.ventas.oct)}</td></tr>
              <tr><th scope="row">Noviembre</th><td class='text-right'>Q.${numFormat(res.ventas.nov)}</td></tr>
              <tr><th scope="row">Diciembre</th><td class='text-right'>Q.${numFormat(res.ventas.dic)}</td></tr>
              <tr><th scope="row" class='text-warning'>TOTAL</th><td class='text-right'>Q.${numFormat(total_anual)}</td></tr>
              `
        }
    }

}

//btnReporteCli(47)

function numFormat(num) {
    return new Intl.NumberFormat("gt-GT").format(num)
}

function sumObj(obj) {
    return Object.keys(obj).reduce((acc, key) => acc + parseFloat(obj[key] || 0), 0);
}

function btnEditarCli(id) {
    if(id===false) return
    
    form.classList.remove('was-validated');
    form.reset();
    $('#nuevo_cliente li a#generales-tab').tab('show')
    //$('#nuevo_cliente li a#tdireccion-tab').tab('show')
    //$('#nuevo_cliente li a#parametros-tab').tab('show')
    //$('#nuevo_cliente li a#tcontacto-tab').tab('show') 

    title.textContent = 'Modificar Cliente';
    btnAccion.textContent = 'Modificar';
    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            pais.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione país";
            option.value = '';
            pais.add(option);

            res.paises.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['pais'];
                option.value = element['cod'];
                pais.add(option);
            });            

            id_vendedor1.innerHTML = "";
            option = document.createElement("option");
            option.text = "Seleccione vendedor";
            option.value = '';
            id_vendedor1.add(option);

            res.vendedores.forEach(function(element) {
                option = document.createElement("option");
                option.text = element['nombre'];
                option.value = element['codven'];
                id_vendedor1.add(option);
            }); 

            id_cliente.value = res.id;
            nombre.value = res.nombre;
            telefono.value = res.telefono;
            mensajeria.value = res.mensajeria;
            tipoid.value = res.tipoid;
            nit.value = res.nit;
            direccion.value = res.direccion;
            municipio.value = res.municipio;
            departamento.value = res.departamento;
            pais.value = res.pais;
            coordenadas.value = res.coordenadas;
            
            tipocliente.value = res.tipocliente;

            contacto.value = res.contacto;
            telcontacto.value = res.telcontacto;
            observaciones.value = res.observaciones;

            limite_credito.value = res.limite_credito;
            dias_credito.value = res.dias_credito;
            id_vendedor1.value = res.id_vendedor1;
            

            if(res.estado==0) {
                $('#estado-0').addClass('d-inline-block').removeClass('d-none');
                $('#estado-1').addClass('d-none').removeClass('d-inline-block');
            } else {
                $('#estado-1').addClass('d-inline-block').removeClass('d-none');
                $('#estado-0').addClass('d-none').removeClass('d-inline-block');
            }

            $('#nuevo_cliente').modal('show');
        }
    }
}

function btnAnotacionesCli(id) {
    if(id===false) return
    form.classList.remove('was-validated');
    form.reset();
    $('#modal_anotaciones li a#tcontacto-tab').tab('show')

    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            id_cliente_anotaciones.value = res.id;
            observaciones_anotaciones.value = res.observaciones;

            $('#modal_anotaciones').modal('show');
        }
    }
}

function btnEliminarCli(id) {
    if(id===false) return
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El cliente no se eliminará de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "clientes/eliminar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    if (res.icono == 'success') {
                        t_cheq.ajax.reload();
                    }
                    
                }
            }
        }
    })
}

function btnReingresarCli(id) {
    Swal.fire({
        title: 'Esta seguro de reingresar?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + "clientes/reingresar/" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    if (res.icono == 'success') {
                        t_cheq.ajax.reload();
                    }
                }
            }

        }
    })
} //fin clientes


let map
let marker
function btnUbicacionCli(id) {
    if(id===false) return
    form.classList.remove('was-validated');
    form.reset();
    $('#modal_anotaciones li a#tcontacto-tab').tab('show')

    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            id_cliente_anotaciones.value = res.id;
            //

            if(res.coordenadas===null) {
                alertas('No tiene coordenadas definidas', 'danger');
            } else {
                let params = res.coordenadas.split('|');

                let lat=Number( params[1] )  //14.640189
                let lng=Number( params[2] ) //-90.519828;

                if(isNaN(lat)===true || isNaN(lng)===true)
                {
                    alertas('No tiene coordenadas definidas', 'danger');
                } else {
                    $('#modal_map').modal('show');
    
                    map = new google.maps.Map(document.getElementById("googleMap"),{
                        center:new google.maps.LatLng(lat, lng),
                        zoom:14,
                    });
    
                    marker = new google.maps.Marker({
                        position: { lat: lat, lng:lng  },
                        map: map,
                        title: res.nombre,
                    });

                }
            }



        }
    }

}

function error(msg) {
    //var s = document.querySelector('#status');
    s.innerHTML = typeof msg == 'string' ? msg : "failed";
    s.className = 'fail';
    console.log(msg)
}


function btnVisitarCli(id) {
    if (navigator.geolocation) {
        var options = {enableHighAccuracy: true,timeout: 5000,maximumAge: 0};
        if (typeof(idgeo) !== 'undefined') navigator.geolocation.clearWatch(idgeo)
        idgeo=navigator.geolocation.getCurrentPosition(function(position) { 
          //getCurrentGeo(position,'coord_entra','fec_entrada',myid,$(this),mypri)
          Mycoords=position.coords.accuracy+"|"+position.coords.latitude+"|"+position.coords.longitude+"|"+id;

          //console.log(Mycoords)

          const url = base_url + 'clientes/registrarVisita/' + Mycoords;

          const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    //alertas(res.msg, res.icono);
                    t_cheq.ajax.reload();
                }                
            }
          /*$.post( "lib/mysql_geolocalizacion_cliente.php",{idcliente:id,coord:Mycoords}, function(data) {
            //console.log(id, Mycoords)    
            load_grid(page_global)
          });*/

        }, error,options);
    } else {
      error('not supported');
    }

}


function btnVervisitaCli(id) {

    if(id===false) return
    form.classList.remove('was-validated');
    form.reset();
    $('#modal_anotaciones li a#tcontacto-tab').tab('show')

    const url = base_url + 'clientes/editar/' + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            
            id_cliente_anotaciones.value = res.id;
            //

            if(res.coord_ultimavisita===null) {
                alertas('No tiene coordenadas definidas', 'danger');
            } else {
                let params = res.coord_ultimavisita.split('|');

                let lat=Number( params[1] )  //14.640189
                let lng=Number( params[2] ) //-90.519828;

                if(isNaN(lat)===true || isNaN(lng)===true)
                {
                    alertas('No tiene coordenadas definidas', 'danger');
                } else {
                    $('#modal_map').modal('show');
    
                    map = new google.maps.Map(document.getElementById("googleMap"),{
                        center:new google.maps.LatLng(lat, lng),
                        zoom:14,
                    });
    
                    marker = new google.maps.Marker({
                        position: { lat: lat, lng:lng  },
                        map: map,
                        title: res.nombre,
                    });

                }
            }



        }
    }

}

function btnProgramarCliActive()
{
    btnProgramarCli( t_cheq.row(active_meta).data().id , active_meta)
}

function btnProgramarCli(id,row) {
    
    formProgramacion.classList.remove('was-validated');
    formProgramacion.reset();
    const validDate=(isValidDate(t_cheq.row(row).data()['programacion'])===true)?t_cheq.row(row).data()['programacion']:'2021-01-01';
    fechaProgramacion.value=validDate;
    IDProgramacion.value=id;
    ROWProgramacion.value=row;
    $('#modal_programacion').modal('show');

}

function btnHistorialvisitasCli(id) {
    if(id===false) return
    window.open(base_url +'clientes/dashboardvisitas/'+id, "_blank");
}

function btnVentasCli(id) {
    if(id===false) return
    window.open(base_url +'clientes/dashboardventas/'+id, "_blank");
}

function isValidDate(dateString) {
    // First check for the pattern
    if (!/^\d{4}-\d{1,2}-\d{1,2}$/.test(dateString)) {
      return false;
    }
  
    // Parse the date parts to integers
    const parts = dateString.split("-");
    const year = parseInt(parts[0], 10);
    const month = parseInt(parts[1], 10);
    const day = parseInt(parts[2], 10);
  
    // Check the ranges of month and year
    if (year < 1000 || year > 3000 || month == 0 || month > 12) {
      return false;
    }
  
    const monthLength = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  
    // Adjust for leap years
    if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0)) {
      monthLength[1] = 29;
    }
  
    // Check the range of the day
    return day > 0 && day <= monthLength[month - 1];
  }






  