<?php
class Home extends Controller
{
    public function __construct() {
        session_start();
        if (!empty($_SESSION['activo'])) {
            header("location: ".base_url. "admin");
        }
        parent::__construct();

      
    }
    public function index()
    {
        $data = $this->model->getVerificar('empresa');
        $this->views->getView('home', "index", $data);
    }
    public function validar()
    {
        if (empty(strClean($_POST['usuario'])) || empty(strClean($_POST['clave']))) {
            $msg = array('msg' => "El usuario y la contraseña es requerido", 'icono' => 'warning');
        } else {
            $usuario = strClean($_POST['usuario']);
            $clave = strClean($_POST['clave']);
            $data = $this->model->getUsuario($usuario);
            
            if ($data != null) {
                if (password_verify($clave, $data['clave'])) {
                    
                    $_SESSION['id_usuario'] = $data['id'];
                    $_SESSION['id_caja'] = $data['id_caja'];
                    $_SESSION['usuario'] = $data['usuario'];
                    $_SESSION['tipousuario'] = $data['tipousuario'];
                    $_SESSION['nombre'] = $data['nombre'];
                    $_SESSION['activo'] = true;
                    $_SESSION['ticket'] = true;
                    //$_SESSION['color_header'] = $empresa['color_header'] ?? 'warning';
                    //$_SESSION['color_navbar'] = $empresa['color_navbar'] ?? '#ffdd00';
                    $this->verificarPermisos($data['id']);
                    $msg = array('msg' => "ok");
                } else {
                    $msg = array('msg' => "Contraseña incorrecta", 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => "El usuario no existe", 'icono' => 'warning');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }






    ## PERMISOS
    public function verificarPermisos($id_usuario)
    {
        //1.- PERMISOS ADMINISTRACIÓN
        $per_admin = $this->model->verificarPermisos($id_usuario, "administracion");
        $data['admin'] = (!empty($per_admin) || $id_usuario == 1) ? true : false;
        //2.- PERMISOS USERS
        $per_users = $this->model->verificarPermisos($id_usuario, "usuarios");
        $data['usuarios'] = (!empty($per_users) || $id_usuario == 1) ? true : false;
        //3.- PERMISOS CAJAS
        $per_caja = $this->model->verificarPermisos($id_usuario, "cajas");
        $data['cajas'] = (!empty($per_caja) || $id_usuario == 1) ? true : false;
        //4.- PERMISOS ARQUEO
        $per_arqueo = $this->model->verificarPermisos($id_usuario, "arqueo caja");
        $data['arqueo'] = (!empty($per_arqueo) || $id_usuario == 1) ? true : false;
        //5.- PERMISOS MOVIMIENTO
        $per_movi = $this->model->verificarPermisos($id_usuario, "movimientos caja");
        $data['movimiento'] = (!empty($per_movi) || $id_usuario == 1) ? true : false;
        //6.- PERMISOS MEDIDAS
        $per_med = $this->model->verificarPermisos($id_usuario, "medidas");
        $data['medidas'] = (!empty($per_med) || $id_usuario == 1) ? true : false;
        //7.- PERMISOS CATEGORIAS
        $per_cat = $this->model->verificarPermisos($id_usuario, "categorias");
        $data['categorias'] = (!empty($per_cat) || $id_usuario == 1) ? true : false;
        //8.- PERMISOS MARCAS
        $per_marc = $this->model->verificarPermisos($id_usuario, "marcas");
        $data['marcas'] = (!empty($per_marc) || $id_usuario == 1) ? true : false;
        //9.- PERMISOS PRODUCTOS
        // $per_pro = $this->model->verificarPermisos($id_usuario, "productos");
        //$data['productos'] = (!empty($per_pro) || $id_usuario == 1) ? true : false;
        //10.- PERMISOS COTIZACIONES
        $per_cot = $this->model->verificarPermisos($id_usuario, "cotizaciones");
        $data['cotizaciones'] = (!empty($per_cot) || $id_usuario == 1) ? true : false;
        //11.- PERMISOS APARTADOS
        $per_apart = $this->model->verificarPermisos($id_usuario, "apartados");
        $data['apartados'] = (!empty($per_apart) || $id_usuario == 1) ? true : false;
        //12.- PERMISOS COMPRAS
        $per_compra = $this->model->verificarPermisos($id_usuario, "compras");
        $data['compras'] = (!empty($per_compra) || $id_usuario == 1) ? true : false;
        //13.- PERMISOS VENTAS
        $per_venta = $this->model->verificarPermisos($id_usuario, "ventas1");
        $data['ventas1'] = (!empty($per_venta) || $id_usuario == 1) ? true : false;
        //14.- PERMISOS CREDITO COMPRAS
        $per_cred_com = $this->model->verificarPermisos($id_usuario, "administrar creditos compras");
        $data['credito_compra'] = (!empty($per_cred_com) || $id_usuario == 1) ? true : false;
        //15.- PERMISOS CREDITO VENTAS
        $per_cred_ven = $this->model->verificarPermisos($id_usuario, "administrar creditos ventas");
        $data['credito_venta'] = (!empty($per_cred_ven) || $id_usuario == 1) ? true : false;
        //16.- PERMISOS PDF
        $per_pdf = $this->model->verificarPermisos($id_usuario, "reportes pdf");
        $data['pdf'] = (!empty($per_pdf) || $id_usuario == 1) ? true : false;
        //17.- PERMISOS EXCEL
        $per_excel = $this->model->verificarPermisos($id_usuario, "reportes excel");
        $data['excel'] = (!empty($per_excel) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //10000- PERMISOS ESCRITORIO
        $per_escritorio = $this->model->verificarPermisos($id_usuario, "Escritorio");
        $data['escritorio'] = (!empty($per_escritorio) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //20000- PERMISOS ACTIVIDAD
        $per_actividad = $this->model->verificarPermisos($id_usuario, "Actividad");
        $data['actividad'] = (!empty($per_actividad) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //30000- PERMISOS AGENDA
        $per_agenda = $this->model->verificarPermisos($id_usuario, "Agenda");
        $data['agenda'] = (!empty($per_agenda) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40000- PERMISOS CLIENTES
        $per_clientes = $this->model->verificarPermisos($id_usuario, "Clientes");
        $data['clientes'] = (!empty($per_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40100- PERMISOS MANTENIMIENTO DE CLIENTES
        $per_mantenimiento_clientes = $this->model->verificarPermisos($id_usuario, "Mantenimiento de clientes");
        $data['mantenimiento de clientes'] = (!empty($per_mantenimiento_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40110- PERMISOS CREAR CLIENTES NUEVOS
        $per_crear_clientes = $this->model->verificarPermisos($id_usuario, "Crear clientes nuevos");
        $data['crear clientes nuevos'] = (!empty($per_crear_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40120- PERMISOS EDITAR DATOS DE CLIENTES
        $per_editar_clientes = $this->model->verificarPermisos($id_usuario, "Editar datos de Cliente");
        $data['editar datos de Cliente'] = (!empty($per_editar_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40130- PERMISOS VER CONFIGURACION DE CLIENTES
        $per_configuracion_clientes = $this->model->verificarPermisos($id_usuario, "Ver configuracion de cliente");
        $data['ver configuracion de cliente'] = (!empty($per_configuracion_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40140- PERMISOS ELIMINAR CLIENTE
        $per_eliminar_clientes = $this->model->verificarPermisos($id_usuario, "Eliminar cliente");
        $data['eliminar cliente'] = (!empty($per_eliminar_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40150- PERMISOS ACCIONES DEL CLIENTE 
        $per_acciones_cliente = $this->model->verificarPermisos($id_usuario, "Acciones del cliente");
        $data['acciones del cliente'] = (!empty($per_acciones_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40151- PERMISOS ACCIONES DEL CLIENTE AGREGAR ANOTACIONES 
        $per_agregar_anotacion = $this->model->verificarPermisos($id_usuario, "Agregar anotaciones cliente");
        $data['agregar anotaciones cliente'] = (!empty($per_agregar_anotacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40152- PERMISOS ACCIONES DEL CLIENTE VER UBICACION
        $per_ver_ubicacion = $this->model->verificarPermisos($id_usuario, "Ver ubicacion cliente");
        $data['ver ubicacion cliente'] = (!empty($per_ver_ubicacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40153- PERMISOS ACCIONES DEL CLIENTE MANDAR MENSAJE
        $per_mandar_mensaje = $this->model->verificarPermisos($id_usuario, "Mandar mensaje cliente");
        $data['mandar mensaje cliente'] = (!empty($per_mandar_mensaje) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40154- PERMISOS ACCIONES DEL CLIENTE LLAMAR
        $per_llamar = $this->model->verificarPermisos($id_usuario, "Llamar cliente");
        $data['llamar cliente'] = (!empty($per_llamar) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40160- PERMISOS PROGRAMACIONES DEL CLIENTE 
        $per_programaciones_cliente = $this->model->verificarPermisos($id_usuario, "Programaciones del cliente");
        $data['programaciones del cliente'] = (!empty($per_programaciones_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40161- PERMISOS PROGRAMACIONES DEL CLIENTE - PROGRAMAR LLAMADA
        $per_programar_llamada = $this->model->verificarPermisos($id_usuario, "Programar llamada cliente");
        $data['programar llamada cliente'] = (!empty($per_programar_llamada) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40162- PERMISOS PROGRAMACIONES DEL CLIENTE - PROGRAMAR COBRO
        $per_progamar_cobro = $this->model->verificarPermisos($id_usuario, "Programar cobro cliente");
        $data['programar cobro cliente'] = (!empty($per_progamar_cobro) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40163- PERMISOS PROGRAMACIONES DEL CLIENTE - PROGRAMAR VISISTA
        $per_programar_visita = $this->model->verificarPermisos($id_usuario, "Programar visita cliente");
        $data['programar visita cliente'] = (!empty($per_programar_visita) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40164- PERMISOS PROGRAMACIONES DEL CLIENTE - MARCAR VISISTA
        $per_marcar_visista = $this->model->verificarPermisos($id_usuario, "Marcar visita cliente");
        $data['marcar visita cliente'] = (!empty($per_marcar_visista) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40170- PERMISOS REPORTE DE SALDO DE CLIENTE 
        $per_reporte_saldo_cliente = $this->model->verificarPermisos($id_usuario, "Reporte de saldo clientes");
        $data['Reporte de saldo clientes'] = (!empty($per_reporte_saldo_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40171- PERMISOS REPORTE DE SALDO DE CLIENTE - ESTADO DE CUENTA
        $per_estado_cuenta = $this->model->verificarPermisos($id_usuario, "Estado de cuenta cliente");
        $data['estado de cuenta cliente'] = (!empty($per_estado_cuenta) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40172- PERMISOS REPORTE DE SALDO DE CLIENTE - ANTIGUEDAD DE SALDOS
        $per_antiguedad_saldos = $this->model->verificarPermisos($id_usuario, "Antiguedad de saldos cliente");
        $data['antiguedad de saldos cliente'] = (!empty($per_antiguedad_saldos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40173- PERMISOS REPORTE DE SALDO DE CLIENTE - CUENTAS POR COBRAR
        $per_cuentas_cobrar = $this->model->verificarPermisos($id_usuario, "Cuentas por cobrar cliente");
        $data['cuentas por cobrar cliente'] = (!empty($per_cuentas_cobrar) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40180- PERMISOS ACCIONES DE VENTAS CLIENTE 
        $per_acciones_ventas_cliente = $this->model->verificarPermisos($id_usuario, "Acciones de ventas clientes");
        $data['acciones de ventas clientes'] = (!empty($per_acciones_ventas_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40181- PERMISOS ACCIONES DE VENTAS CLIENTE - NUEVO PEDIDO
        $per_nuevo_pedido_cliente = $this->model->verificarPermisos($id_usuario, "Nuevo pedido cliente");
        $data['nuevo pedido cliente'] = (!empty($per_nuevo_pedido_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40182- PERMISOS ACCIONES DE VENTAS CLIENTE - NUEVO FACTURA
        $per_nueva_factura = $this->model->verificarPermisos($id_usuario, "Nueva factura cliente");
        $data['nueva factura cliente'] = (!empty($per_nueva_factura) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40183- PERMISOS ACCIONES DE VENTAS CLIENTE - NUEVO RECIBO
        $per_nuevo_recibo = $this->model->verificarPermisos($id_usuario, "Nuevo recibo cliente");
        $data['nuevo recibo cliente'] = (!empty($per_nuevo_recibo) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40190- PERMISOS CRM DEL CLIENTES 
        $per_crm_cliente = $this->model->verificarPermisos($id_usuario, "CRM del cliente");
        $data['crm del cliente'] = (!empty($per_crm_cliente) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40200- PERMISOS PAGOS Y ABONOS DE CLIENTES
        $per_pago_abono_clientes = $this->model->verificarPermisos($id_usuario, "Pago y abonos de clientes");
        $data['pago y abonos de clientes'] = (!empty($per_pago_abono_clientes) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40210- PERMISOS AGREGAR PAGO O ABONO
        $per_agregar_pago = $this->model->verificarPermisos($id_usuario, "Agregar pago o abono");
        $data['agregar pago o abono'] = (!empty($per_agregar_pago) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40220- PERMISOS VER PAGO O ABONO
        $per_ver_pago = $this->model->verificarPermisos($id_usuario, "Ver pago o abono");
        $data['ver pago o abono'] = (!empty($per_ver_pago) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //40230- PERMISOS ANULAR PAGO O ABONO
        $per_anular_pago = $this->model->verificarPermisos($id_usuario, "Anular pago o abono");
        $data['anular pago o abono'] = (!empty($per_anular_pago) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50000- PERMISOS PRODUCTOS
        $per_productos = $this->model->verificarPermisos($id_usuario, "Productos");
        $data['productos'] = (!empty($per_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50100- PERMISOS MANTENIMIENTO DE PRODUCTOS
        $per_mantenimiento_productos = $this->model->verificarPermisos($id_usuario, "Mantenimiento de productos");
        $data['mantenimiento de productos'] = (!empty($per_mantenimiento_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50110- PERMISOS AGREGAR PRODUCTO
        $per_agregar_producto = $this->model->verificarPermisos($id_usuario, "Agregar producto");
        $data['agregar producto'] = (!empty($per_agregar_producto) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50120- PERMISOS EDITAR PRODUCTO
        $per_editar_producto = $this->model->verificarPermisos($id_usuario, "Editar producto");
        $data['editar producto'] = (!empty($per_editar_producto ) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50130- PERMISOS ELIMINAR PRODUCTO
        $per_eliminar_producto = $this->model->verificarPermisos($id_usuario, "Eliminar producto");
        $data['eliminar producto'] = (!empty($per_eliminar_producto) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50140- PERMISOS REINGRESAR PRODUCTO
        $per_reingresar_producto = $this->model->verificarPermisos($id_usuario, "Reingresar producto");
        $data['reingresar producto'] = (!empty($per_reingresar_producto) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50150- PERMISOS VER PRODUCTOS
        $per_ver_producto = $this->model->verificarPermisos($id_usuario, "Ver producto");
        $data['ver producto'] = (!empty($per_ver_producto) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50160- PERMISOS LISTAR PRECIOS PRODUCTOS
        $per_listar_precios_producto = $this->model->verificarPermisos($id_usuario, "Listar precios productos");
        $data['listar precios productos'] = (!empty($per_listar_precios_producto) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50161- PERMISOS LISTAR PRECIOS PRODUCTOS - LISTADO DE PRECIOS PDF
        $per_listado_pdf = $this->model->verificarPermisos($id_usuario, "Lista de precios PDF productos");
        $data['lista de precios pdf productos'] = (!empty($per_listado_pdf) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50162- PERMISOS LISTAR PRECIOS PRODUCTOS - LISTADO DE PRECIOS EXCEL
        $per_listado_excel = $this->model->verificarPermisos($id_usuario, "Lista de precios excel productos");
        $data['lista de precios excel productos'] = (!empty($per_listado_excel) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50170- PERMISOS OPCIONES DE CATALOGO
        $per_catalogo_productos = $this->model->verificarPermisos($id_usuario, "Opciones de catalogo");
        $data['opciones de catalogo'] = (!empty($per_catalogo_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50171- PERMISOS OPCIONES DE CATALOGO - FICHA TECNICA DE PRODUCTOS
        $per_ficha_tecnica = $this->model->verificarPermisos($id_usuario, "Ficha tecnica productos");
        $data['ficha tecnica productos'] = (!empty($per_ficha_tecnica) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50172- PERMISOS OPCIONES DE CATALOGO - CATALOGO DE PRODUCTOR
        $per_catalogo = $this->model->verificarPermisos($id_usuario, "Catalogo de productos");
        $data['catalogo de productos'] = (!empty($per_catalogo) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50180- PERMISOS KARDEX
        $per_kardex = $this->model->verificarPermisos($id_usuario, "Kardex");
        $data['kardex'] = (!empty($per_kardex) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50200- PERMISOS MEDIDAS DE PRODUCTOS
        $per_medidas_productos = $this->model->verificarPermisos($id_usuario, "Medidas de productos");
        $data['medidas de productos'] = (!empty($per_medidas_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50210- PERMISOS AGREGAR MEDIDA DE PRODUCTOS
        $per_agreagar_medida = $this->model->verificarPermisos($id_usuario, "Agregar medida");
        $data['agregar medida'] = (!empty($per_agreagar_medida) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50220- PERMISOS EDITAR MEDIDAS DE PRODUCTOS
        $per_editar_medida = $this->model->verificarPermisos($id_usuario, "Editar medida");
        $data['editar medida'] = (!empty($per_editar_medida) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50230- PERMISOS ELIMINAR O REINGRESAR PRODUCTOS
        $per_eli_reing_medida = $this->model->verificarPermisos($id_usuario, "Eliminar o reingresar medida");
        $data['eliminar o reingresar medida'] = (!empty($per_eli_reing_medida) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50300- PERMISOS CATEGORIAS DE PRODUCTOS
        $per_categorias_productos = $this->model->verificarPermisos($id_usuario, "Categorias de productos");
        $data['categorias de productos'] = (!empty($per_categorias_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50310- PERMISOS AGREGAR CATEGORIA DE PRODUCTOS
        $per_agreagar_categoria = $this->model->verificarPermisos($id_usuario, "Agregar categoria");
        $data['agregar categoria'] = (!empty($per_agreagar_categoria) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50320- PERMISOS EDTIAR CATEGORIA DE PRODUCTOS
        $per_editar_categoria = $this->model->verificarPermisos($id_usuario, "Editar categoria");
        $data['editar categoria'] = (!empty($per_editar_categoria) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50330- PERMISOS ELINMINAR Y REINGRESAR CATEGORIA DE PRODUCTOS
        $per_eli_reing_categoria = $this->model->verificarPermisos($id_usuario, "Eliminar y reingresar categoria");
        $data['eliminar y reingresar categoria'] = (!empty($per_eli_reing_categoria) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data; 
        //50340- PERMISOS GENERAR CATALOGO CATEGORIAS DE PRODUCTOS
        $per_catalogo_categorias = $this->model->verificarPermisos($id_usuario, "Generar catalogo categorias");
        $data['generar catalogo categorias'] = (!empty($per_catalogo_categorias) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50400- PERMISOS MARCAS DE PRODUCTOS
        $per_marcas_productos = $this->model->verificarPermisos($id_usuario, "Marcas de productos");
        $data['marcas de productos'] = (!empty($per_marcas_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50410- PERMISOS AGREGAR MARCA DE PRODUCTOS
        $per_agregar_marca = $this->model->verificarPermisos($id_usuario, "Agregar marca");
        $data['agregar marca'] = (!empty($per_agregar_marca) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50420- PERMISOS EDITAR MARCA DE PRODUCTOS
        $per_editar_marca = $this->model->verificarPermisos($id_usuario, "Editar marca");
        $data['editar marca'] = (!empty($per_editar_marca) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50430- PERMISOS ELIMINAR O REINGRESAR MARCA DE PRODUCTOS
        $per_Eli_reing_marca = $this->model->verificarPermisos($id_usuario, "Eliminar o reingresar marca");
        $data['eliminar o reingresar marca'] = (!empty($per_Eli_reing_marca) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //50500- PERMISOS INGRESO RECIENTES DE PRODUCTOS
        $per_ingresorec_productos = $this->model->verificarPermisos($id_usuario, "Ingresos recientes de productos");
        $data['ingresos recientes de productos'] = (!empty($per_ingresorec_productos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60000- PERMISOS VENDEDORES
        $per_vendedores = $this->model->verificarPermisos($id_usuario, "Vendedores");
        $data['vendedores'] = (!empty($per_vendedores) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60100- PERMISOS MANTENIMIENTO DE VENDEDORES
        $per_mantenimiento_vendedores = $this->model->verificarPermisos($id_usuario, "Mantenimiento de vendedores");
        $data['mantenimiento de vendedores'] = (!empty($per_mantenimiento_vendedores) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60110- PERMISOS WHATSAPP DEL VENDEDOR
        $per_whatsapp_vendedor = $this->model->verificarPermisos($id_usuario, "Whatsapp vendedor");
        $data['whatsapp vendedor'] = (!empty($per_whatsapp_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60120- PERMISOS UBICACION DEL VENDEDOR
        $per_ubicacion_vendedor = $this->model->verificarPermisos($id_usuario, "Ubicacion vendedor");
        $data['ubicacion vendedor'] = (!empty($per_ubicacion_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60130- PERMISOS COBROS DEL VENDEDOR
        $per_cobros_vendedor = $this->model->verificarPermisos($id_usuario, "Cobrar vendedor");
        $data['cobrar vendedor'] = (!empty($per_cobros_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60140- PERMISOS LLAMAR VENDEDOR
        $per_llamar_vendedor = $this->model->verificarPermisos($id_usuario, "Llamar vendedor");
        $data['llamar vendedor'] = (!empty($per_llamar_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60150- PERMISOS ANTIGUEDAD DE SALDOS DEL VENDEDOR
        $per_saldos_vendedor = $this->model->verificarPermisos($id_usuario, "Antiguedad saldos vendedor ");
        $data['antiguedad saldos vendedor'] = (!empty($per_saldos_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60160- PERMISOS CUNETAS POR COBRAR DEL VENDEDOR
        $per_cuenta_vendedor = $this->model->verificarPermisos($id_usuario, "Cuentas por cobrar vendedor");
        $data['cuentas por cobrar vendedor'] = (!empty($per_cuenta_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60170- PERMISOS HISTORIAL DE VISITAS DEL VENDEDOR
        $per_visitas_vendedor = $this->model->verificarPermisos($id_usuario, "Historial visitas vendedor");
        $data['historial visitas vendedor'] = (!empty($per_visitas_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60180- PERMISOS REPORTE DEL VENDEDOR
        $per_reporte_vendedor = $this->model->verificarPermisos($id_usuario, "Reporte vendedor");
        $data['reporte vendedor'] = (!empty($per_reporte_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60190- PERMISOS VENTAS DEL VENDEDOR
        $per_ventas_vendedor = $this->model->verificarPermisos($id_usuario, "Ventas vendedor");
        $data['ventas vendedor'] = (!empty($per_ventas_vendedor) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //60200- PERMISOS RUTA VENDEDORES
        $per_ruta_vendedores = $this->model->verificarPermisos($id_usuario, "Ruta vendedores");
        $data['ruta vendedores'] = (!empty($per_ruta_vendedores) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70000- PERMISOS VENTAS
        $per_ventas = $this->model->verificarPermisos($id_usuario, "Ventas");
        $data['ventas'] = (!empty($per_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70100- PERMISOS COTIZACIONES DE VENTAS
        $per_cotizacion_ventas = $this->model->verificarPermisos($id_usuario, "Cotizaciones de ventas");
        $data['cotizaciones de ventas'] = (!empty($per_cotizacion_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70110- PERMISOS AGREGAR COTIZACION
        $per_agregar_cotizacion = $this->model->verificarPermisos($id_usuario, "Agregar cotizacion");
        $data['agregar cotizacion'] = (!empty($per_agregar_cotizacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70120- PERMISOS CAMBIAR TIPO DE COTIZACION
        $per_tipo_cotizacion = $this->model->verificarPermisos($id_usuario, "Cambiar tipo cotizacion");
        $data['cambiar tipo cotizacion'] = (!empty($per_tipo_cotizacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70130- PERMISOS CAMBIAR ESTADO COTIZACION
        $per_estado_cotizacion = $this->model->verificarPermisos($id_usuario, "Cambiar estado cotizacion");
        $data['cambiar estado cotizacion'] = (!empty($per_estado_cotizacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70140- PERMISOS VER PDF 1 DE COTIZACION
        $per_pdf1_cotizacion = $this->model->verificarPermisos($id_usuario, "Ver PDF 1");
        $data['ver PDF 1'] = (!empty($per_pdf1_cotizacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70150- PERMISOS VER PDF 2 DE COTIZACION
        $per_pdf2_cotizacion = $this->model->verificarPermisos($id_usuario, "Ver PDF 2");
        $data['ver PDF 2'] = (!empty($per_pdf2_cotizacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70160- PERMISOS CRM DEL CLIENTE COTIZACION
        $per_crm_cotizacion = $this->model->verificarPermisos($id_usuario, "CRM cliente cotizacion");
        $data['crm del cliente cotizacion'] = (!empty($per_crm_cotizacion) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70200- PERMISOS PEDIDOS DE VENTAS
        $per_pedidos_ventas = $this->model->verificarPermisos($id_usuario, "Pedidos de ventas");
        $data['pedidos de ventas'] = (!empty($per_pedidos_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70210- PERMISOS AGREGAR NUEVO PEDIDO
        $per_nuevo_pedido = $this->model->verificarPermisos($id_usuario, "Agregar nuevo pedido");
        $data['agregar nuevo pedido'] = (!empty($per_nuevo_pedido) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70220- PERMISOS CAMBIAR TIPO DE PEDIDO
        $per_cambiar_tipo_pedidos = $this->model->verificarPermisos($id_usuario, "Cambiar tipo de pedido");
        $data['cambiar tipo de pedido'] = (!empty($per_cambiar_tipo_pedidos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70230- PERMISOS CAMBIAR ESTA DEL PEDIDO
        $per_cambiar_estado_pedido = $this->model->verificarPermisos($id_usuario, "Cambiar estado del pedido");
        $data['cambiar estado del pedido'] = (!empty($per_cambiar_estado_pedido) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70240- PERMISOS VER PDF 1
        $per_pdf1_pedido = $this->model->verificarPermisos($id_usuario, "Ver PDF 1");
        $data['ver pdf 1'] = (!empty($per_pdf1_pedido) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70250- PERMISOS VER PDF 2
        $per_pdf2_pedidos = $this->model->verificarPermisos($id_usuario, "Ver PDF 2");
        $data['ver pdf 2'] = (!empty($per_pdf2_pedidos) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70260- PERMISOS CRM DEL CLIENTE PEDIDOS
        $per_crm_cliente_pedido = $this->model->verificarPermisos($id_usuario, "CRM del cliente pedidos");
        $data['crm del cliente pedidos'] = (!empty($per_crm_cliente_pedido) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70300- PERMISOS FACTURAS DE VENTAS
        $per_facturas_ventas = $this->model->verificarPermisos($id_usuario, "Facturas de ventas");
        $data['facturas de ventas'] = (!empty($per_facturas_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70300- PERMISOS ANULAR FACTURA
        $per_anular_factura = $this->model->verificarPermisos($id_usuario, "Anular Factura");
        $data['anular Factura'] = (!empty($per_anular_factura) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70300- PERMISOS FACTURAR FEL
        $per_facturar_fel = $this->model->verificarPermisos($id_usuario, "Facturar FEL");
        $data['facturar fel'] = (!empty($per_facturar_fel) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70300- PERMISOS VER FACTURA
        $per_ver_factura = $this->model->verificarPermisos($id_usuario, "Ver factura");
        $data['ver factura'] = (!empty($per_ver_factura) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70400- PERMISOS ENVIOS DE VENTAS
        $per_envios_ventas = $this->model->verificarPermisos($id_usuario, "Envios de ventas");
        $data['envios de ventas'] = (!empty($per_envios_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //70500- PERMISOS HISTORIAL DE VENTAS
        $per_historial_ventas = $this->model->verificarPermisos($id_usuario, "Historial de ventas");
        $data['historial de ventas'] = (!empty($per_historial_ventas) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
        //80000- PERMISOS DEVOLUCIONES
        $per_devoluciones = $this->model->verificarPermisos($id_usuario, "Devoluciones");
        $data['devoluciones'] = (!empty($per_devoluciones) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
         //80100- PERMISOS NOTAS DE CAMBIO DEVOLUCIONES
        $per_notas_cambio_devoluciones = $this->model->verificarPermisos($id_usuario, "Notas de cambio devoluciones");
        $data['notas de cambio devoluciones'] = (!empty($per_notas_cambio_devoluciones) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;
         //80200- PERMISOS NOTAS DE DEVOLUCIONES
        $per_notas_devoluciones = $this->model->verificarPermisos($id_usuario, "Notas de devoluciones ");
        $data['notas de devoluciones'] = (!empty($per_notas_devoluciones) || $id_usuario == 1) ? true : false;
        $_SESSION['permisos'] = $data;

    }
}
