let t_h_v;

let active_row=false;
let active_obj=false;


document.addEventListener('DOMContentLoaded', function () {

    //DataTables Historial Ventas - Ajax
    t_h_v = $('#t_recibos').DataTable({
        "aPreocesing": true,
        "aServerSide": false,
        "ajax": {
            "url": "" + base_url + 'recibos/listar_recibos',
            "dataSrc": ""
        },
        "columns": [{"data": "id"},
                    {"data": "nombre"},
                    {"data": "total"},
                    {"data": "fecha"},
                    {"data": "forma"},
                    {"data": "estado"},
                    {"data": "anotacion"},
                    {"data": "sucursal"},
                    {"data": "idsucursal", name: 'idsucursal', 'visible' : false}
               ],
        "columnDefs": [
                { responsivePriority: 30000, targets: -2 },
                { responsivePriority: 30000, targets: -1 }
            ],
        "drawCallback": function () {
            let api = this.api();
            $(api.columns(2).footer()).html(
                //'Total:  Q.' + api.columns(2).data().sum().toFixed(2)
                'Total:  Q.' + api.columns(2,{search:'applied'}).data().sum().toFixed(2)
            )
            /*$(api.columns(2).footer()).html(
                'Total:  ' + api.columns(2, {
                    page: 'current'
                }).data().sum()
            ) */           
        },
        "dom": "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        buttons,
        language,
        "resonsieve": true,
        "responsive": true,
        "bDestroy": true,
        "iDisplayLength": 10,
        "order": [
            [0, "desc"]
        ]
    });

    t_h_v.on( 'draw', function () {
        $('#t_recibos tbody tr').removeClass('selected');
        activo_buttons(false)
    } );

    $('#t_recibos tbody').on( 'click', 'tr', function (e) {
        let classList = e.currentTarget.classList;
       
        if (classList.contains('selected')) {
            classList.remove('selected');
        }
        else {
            t_h_v.rows('.selected').nodes().each((row) => row.classList.remove('selected'));
            classList.add('selected');
        }
        activo_buttons( t_h_v.row( this ).data()  );
    } );

    function activo_buttons(obj)
    {
        active_obj=obj;
        active_row=active_obj.id;

        if($('#t_recibos tbody tr.selected').length==0)
        {
            $('BUTTON.btn-toolbar-status').attr('disabled', 'disabled');
            $('BUTTON.btn-recuperar').hide();
            $('BUTTON.btn-eliminar').show();            
        } else {
            $('BUTTON.btn-toolbar-status').removeAttr('disabled');

            if(active_obj.estado_txt==='emitido') {
                $('BUTTON.btn-anular').show();
            } else {
                $('BUTTON.btn-anular').hide();
            }
            
        }
    }
    

    $('#min').change(function (e) {
        t_h_v.draw();
    });
    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#max').change(function (e) {
        t_h_v.draw();
    });

    //Busqueda por Rango de Fechas DataTables - Hasta
    $('#estaciones').change(function (e) {
        let columns = t_h_v.settings().init().columns;
        let myindex=false;
        t_h_v.columns().every(function (index) { if(columns[index].name=='idsucursal') { myindex=index } });
        t_h_v.column(myindex).search($('#estaciones').val()).draw();
    });  

})
function btnAnular(id) {
    Swal.fire({
        title: 'Esta seguro de anular el Recibo?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + 'recibos/anular/' + id;

            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                    t_h_v.ajax.reload();
                }
            }
        }
    })
}
function btnFacturarFel(id)
{
    Swal.fire({
        title: 'Esta seguro de facturar la Venta?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = base_url + 'recibos/registrarFactura/' + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    if(res.icono=='success')
                    {
                        alertas(res.msg, res.icono);
                        t_h_v.ajax.reload();
                        //generar PDF                        
                    } else {
                        alerta_permanent(res.msg, res.icono);
                    }
                }
            }
        }
    })
}

function open_vales_excel(iduser)
{
    let min=document.getElementById('min').value;
    let max=document.getElementById('max').value;
    let estacion=document.getElementById('estaciones').value;
    
    let search={ min, max, search:t_h_v.search(), iduser, estacion }
    let href=base_url+"recibos/excel?search="+btoa(JSON.stringify(search))
    open_link(href)
}

function btnWhatsappRec(id)
{
    if(id===false) return;

    let mensajeria=t_h_v.rows('.selected').data();
    const filteredStr = mensajeria[0].mensajeria.replace(/\D/g, '');

    if(filteredStr.length==8)
    {
        newTab = window.open('https://api.whatsapp.com/send?phone=502'+filteredStr, "myNewWindow", "width=500,height=500");
        setTimeout(() => { 
            newTab.window.close();
        }, 1000);
    } else {
        alertas('No tiene definido un número de mensajería válido', 'danger');
    }
   
}