<?php

use Luecano\NumeroALetras\NumeroALetras;

class Apartados extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }
    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'jquery-ui.min.js'),
            array('script' => 'pages/apartados.js')
        );
        $this->views->getView('apartados', "index", $data);
    }
    public function registrarApartado($id_pro)
    {
        $datos = $this->model->getProducto($id_pro);
        $precio = $datos['precio_venta'];
        $cantidad = 1;
        $comprobar = $this->model->getComprobar($id_pro, $this->id_usuario, 'detalle_temp_apartado');
        $cantidad_dis = $datos['cantidad'];
        if ($cantidad_dis < $cantidad) {
            $msg = array('msg' => 'No hay Stock, te quedan ' . $cantidad_dis, 'icono' => 'warning');
        } else {
            if (empty($comprobar)) {
                $sub_total = $precio * $cantidad;
                $data = $this->model->registrarDetalleApart($id_pro, $this->id_usuario, $precio, $cantidad, $sub_total);
                if ($data == "ok") {
                    $msg = array('msg' => 'Producto ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al ingresar el producto', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'El producto ya esta agregado', 'icono' => 'error');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function listar()
    {
        $data['detalle'] = $this->model->getDetalle($this->id_usuario);
        $data['total_pagar'] = $this->model->calcularTotal($this->id_usuario);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function delete($id)
    {
        $data = $this->model->deleteDetalle($id, 'detalle_temp_apartado');
        if ($data == 'ok') {
            $msg = array('msg' => 'Producto Eliminado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el producto', 'icono' => 'error');
        }
        echo json_encode($msg);
        die();
    }
    //apartado productos
    public function cantidad($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $cant = $array[1];
        if (is_numeric($id) && is_numeric($cant)) {
            if ($cant > 0) {
                $stock = $this->model->verificarStock('detalle_temp_apartado', $id);
                if ($cant <= $stock['cantidad']) {
                    $data = $this->model->actualizarCantidad('detalle_temp_apartado', $cant, $id);
                    if ($data == 'ok') {
                        $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                    } else {
                        $msg = array('msg' => 'Error al agregar la cantidad', 'icono' => 'error');
                    }
                } else {
                    $this->model->actualizarCantidad('detalle_temp_apartado', $stock['cantidad'], $id);
                    $msg = array('msg' => 'Stock Disponible solo ' . $stock['cantidad'], 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode(
            $msg,
            JSON_UNESCAPED_UNICODE
        );
        die();
    }
    public function apartarProducto()
    {
        $id_cliente = $_POST['id_cliente'];
        $retiro = $_POST['retiro'];
        $monto_abono = $_POST['monto_abono'];
        $nota = $_POST['nota'];
        $data = $this->model->getDetalle($this->id_usuario);
        $pagar = $this->model->calcularTotal($this->id_usuario);
        $fecha = date('Y-m-d');
        $folio = $this->model->insertarApartado($this->id_usuario, $pagar['total'], $id_cliente, $retiro, $monto_abono, $nota, $fecha);
        if ($folio > 0) {
            foreach ($data as $row) {
                $id_pro = $row['id_producto'];
                $cantidad = $row['cantidad'];
                $desc = $row['descuento'];
                $precio = $row['precio'];
                $sub_total = $row['sub_total'];
                $this->model->registrar('detalle_apartado', $folio, $id_pro, $cantidad, $desc, $precio, $sub_total);
                $stock = $this->model->getProducto($id_pro);
                $total_cantidad = $stock['cantidad'] - $row['cantidad'];
                $this->model->actualizarStock($total_cantidad, $stock['id']);
            }
            $eliminar = $this->model->eliminarTemp($this->id_usuario, 'detalle_temp_apartado');
            if ($eliminar == 'ok') {
                $msg = array('msg' => 'Productos Apartado con éxito', 'folio' => $folio, 'icono' => 'success');
            }
        } else {
            $msg = array('msg' => 'Error al apartar los productos', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function descuento($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $desc = $array[1];
        if (is_numeric($id) && is_numeric($desc)) {
            $data = $this->model->actualizarDescuento('detalle_temp_apartado', $desc, $id);
            if ($data == 'ok') {
                $msg = array('msg' => 'Descuento Agregado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al agregar el descuento', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function historial()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'pages/historial_apartados.js')
        );
        $this->views->getView('apartados', "historial", $data);
    }
    public function listarApartados()
    {
        $data = $this->model->getHistorial('apartados', $this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]['estado'] == 1) {
                $data[$i]['estado'] = '<span class="badge badge-warning">Pendiente</span>';
                $data[$i]['acciones'] = '<div>
                    <a href="' . base_url . "apartados/pdfApartado/" . $data[$i]['id'] . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <button class="btn btn-outline-info" type="button" onclick="verApartado(' . $data[$i]['id'] . ');"><i class="fas fa-eye"></i></button>
                    <div/>';
            } else {
                $data[$i]['estado'] = '<span class="badge badge-success">Entregado</span>';
                $data[$i]['acciones'] = '<div>
                    <a href="' . base_url . "apartados/pdfApartado/" . $data[$i]['id'] . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <div/>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function verDetalle(int $folio)
    {
        $data['fecha'] = date('Y-m-d');
        $data['apartado'] = $this->model->getApartado($folio);
        $data['productos'] = $this->model->detalleApartados($folio);
        $data['total'] = 0.00;
        foreach ($data['productos'] as $row) {
            $data['total'] = $data['total'] + $row['sub_total'];
        }
        $data['total_apartado'] = $data['total'];
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function generarVenta($id)
    {
        if (is_numeric($id)) {
            $data = $this->model->actualizarEstado('apartados', 0, $id);
            if ($data == 'ok') {
                $tipo = 1;
                $data = $this->model->getApartado($id);
                $productos = $this->model->getDetalleApartado($id);
                $fecha = date('Y-m-d');
                $hora = date('H:i:s');
                $v_serie = $this->model->serie('ventas', $tipo);
                $serie = $v_serie['serie'] + 1;
                $id_venta = $this->model->insertarVenta($this->id_usuario, $data['total'], $data['id_cliente'], $fecha, $hora, 1, $tipo, $serie);
                if ($id_venta > 0) {
                    foreach ($productos as $row) {
                        $id_pro = $row['id_producto'];
                        $cantidad = $row['cantidad'];
                        $desc = $row['descuento'];
                        $precio = $row['precio'];
                        $sub_total = $row['sub_total'];
                        $this->model->registrar('detalle_ventas', $id_venta, $id_pro, $cantidad, $desc, $precio, $sub_total);
                    }
                    $msg = array('msg' => 'Venta Generada', 'id_venta' => $id_venta, 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al apartar los productos', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'Error al entregar los productos', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Error Fatal', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function pdfApartado($folio)
    {
        $data['empresa'] = $this->model->getEmpresa();
        $data['apartado'] = $this->model->getApartado($folio);
        $data['detalle'] = $this->model->detalleApartados($folio);
        ob_start();
        $html = $this->views->getView('apartados', "reporte", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
}
