<?php
class Cheques extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        parent::__construct();
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'moment.min.js'),         
            array('script' => 'chart.min.js'),            
            array('script' => 'pages/cheques.js'),
        );
        $this->views->getView('cheques', "index", $data);
    }

    public function listar()
    {
        $data = $this->model->getCheques();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }


    function isValidDate($dateString, $format = 'Y-m-d') {
        $dateTime = DateTime::createFromFormat($format, $dateString);
        return $dateTime && $dateTime->format($format) === $dateString;
    }    

}
