<?php
class Creditoventas extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    //Creditos Ventas
    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'pages/credito-ventas.js')
        );
        $this->views->getView('ventas', "creditos", $data);
    }

    public function listar()
    {


        $data = $this->model->getCreditos($this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            $estado = ($data[$i]['estatus'] == 0) ? 2 : $data[$i]['estado'];
            if ($estado == 1) {
                $data[$i]['estado'] = '<span class="badge badge-warning">Pendiente</span>';
                $data[$i]['acciones'] = '';
                /*'<div class="d-flex">
                <button class="btn btn-warning" type="button" onclick="nuevo_abono(' . $data[$i]['id'] . ');"><i class="far fa-credit-card"></i></button>
                <div/>';
                */
            } else if ($estado == 2) {
                $data[$i]['estado'] = '<span class="badge badge-danger">Anulado</span>';
                $data[$i]['acciones'] = '<div>
                <div/>';
            } else {
                $data[$i]['estado'] = '<span class="badge badge-success">Finalizado</span>';
                $data[$i]['acciones'] = '<div>
                <div/>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function registrar()
    {
        $data['nrecibo'] = $this->model->getCountRecibos($this->id_usuario);
        $data['metodos'] = $this->model->getMetodos();
        $data['bancos'] = $this->model->getBancos();        
        $data['scripts'] = array(
            array('script' => 'jquery-ui.min.js'),
            array('script' => 'pages/registrar-abonos.js')
        );
        $this->views->getView('creditoventas', "index", $data);        
    }


    public function listar_creditos()
    {
        $data = $this->model->getCreditosCliente($_GET['id']);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function abonos()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'pages/abono-ventas.js')
        );
        $this->views->getView('ventas', "abonos", $data);
    }


    public function listar_abonos()
    {
        $data = $this->model->getAbonos($this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['nombre'] = '[ ' .$data[$i]['id_cliente'] . ' ]-' . $data[$i]['nombre'];
/*            $data[$i]['acciones'] = '<div>
                <button class="btn btn-success" type="button" onclick="autoriza_abono(' . $data[$i]['id'] . ');"><i class="far fa-credit-card"></i></button>
                <button class="btn btn-danger" type="button" onclick="rechaza_abono(' . $data[$i]['id'] . ');"><i class="far fa-credit-card"></i></button>
            <div/>';*/
            /*$estado = ($data[$i]['estado'] == 0) ? 2 : $data[$i]['estado'];
            if ($estado == 1) {
                $data[$i]['estado'] = '<span class="badge badge-warning">Pendiente</span>';
            } else if ($estado == 2) {
                $data[$i]['estado'] = '<span class="badge badge-danger">Anulado</span>';
                //$data[$i]['acciones'] = '<div><div/>';
            } else {
                $data[$i]['estado'] = '<span class="badge badge-success">Finalizado</span>';
                //$data[$i]['acciones'] = '<div><div/>';
            }*/

        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

// <a class="btn btn-danger" href="' . base_url . 'creditos/pdfAbono/' . $data[$i]['id'] . '" target="_blank"><i class="fas fa-file-pdf"></i></a>

    public function generarAbono()
    {
        $nrecibo = $this->model->getCountRecibos($this->id_usuario);
        $id_cliente = strClean($_POST['id_cliente']);
        $fecha_abono = strClean($_POST['fecha']);
        $metodo = strClean($_POST['tipo']);
        $banco = strClean($_POST['banco']);
        $referencias = strClean($_POST['referencias']);
        $observaciones = strClean($_POST['observaciones']);
        $monto = strClean($_POST['monto']);
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');        

        $creditos = json_decode($_POST['creditos'],true);

        /*$msg = array('msg' => var_export($creditos, true), 'icono' => 'success', 'id' => $data);
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
        exit;*/


        if (empty($monto) && count($creditos)> 0) {
            $msg = array('msg' => 'Los campos con * son requeridos', 'icono' => 'error');
        } else {
            $id_abono = $this->model->registrarAbonos($id_cliente,$monto, $fecha, $hora, $this->id_usuario, $fecha_abono, $metodo, $observaciones, $referencias, $banco,$nrecibo);
            $this->model->addCountRecibos($this->id_usuario);
            foreach($creditos as $credito) {
                $data = $this->model->registrarAbonoDetalle($id_abono, $credito['numero'], $credito['abono']);
                $data = $this->model->registrarAbonoCredito($credito['numero'], $credito['abono']);
            }
            $this->model->registrarEstadoAbono($id_abono);
            $msg = array('msg' => 'Abono registrado', 'icono' => 'success', 'id' => $id_abono);
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();

    }

    public function registrarAbono()
    {
        $datos = $this->model->getCajaCierre($this->id_usuario);
        if (empty($datos)) {
            $msg = array('msg' => 'La caja esta cerrada', 'icono' => 'warning');
        } else {
            $monto = strClean($_POST['monto']);
            $id = strClean($_POST['id']);
            $id_cliente = strClean($_POST['id_cliente']);
            $fecha = date('Y-m-d');
            $hora = date('H:i:s');
            $fecha_abono = strClean($_POST['fecha']);
            $tipo = strClean($_POST['tipo']);
            $banco = strClean($_POST['banco']);
            $observaciones = strClean($_POST['observaciones']);
            $referencias = strClean($_POST['referencias']);
            if (empty($monto) || empty($id)) {
                $msg = array('msg' => 'Los campos con * son requeridos', 'icono' => 'error');
            } else {
                $data = $this->model->registrarAbono($id, $id_cliente, $monto, $fecha, $hora, $this->id_usuario, $fecha_abono, $tipo, $observaciones, $referencias,$banco);
                if ($data > 0) {
                    $credito = $this->model->getAbono($id);
                    $abonado = $credito['abonado'] + $monto;
                    $restante = $credito['monto'] - $abonado;
                    $abono = $this->model->actualizarCredito('creditos', $abonado, $restante, $id);
                    if ($abono == 'ok') {
                        if ($restante == 0) {
                            $this->model->estado('creditos', 0, $id);
                            $venta = $this->model->estadoVenta($id);
                            $this->model->estado('ventas', 2, $venta['venta']);
                        }
                        $msg = array('msg' => 'Abono registrado', 'icono' => 'success', 'id' => $data);
                    }
                } else {
                    $msg = array('msg' => 'Error al registrar el abono', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function abonar(int $id)
    {
        $data = $this->model->getAbono($id);
        $data['metodos'] = $this->model->getMetodos();
        $data['bancos'] = $this->model->getBancos();
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function autorizaAbono(int $id)
    {
        $data = $this->model->autorizaAbono($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function rechazaAbono(int $id)
    {
        $data = $this->model->rechazarAbono($id);        
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function pdfCredito($id)
    {
        $detalle = $this->model->detalleCredito($id);
        if (!empty($detalle)) {
            $data['abonos'] = $this->model->detalleAbono($id);
            $data['credito'] = $this->model->detalleCliente($id);
            $data['empresa'] = $this->model->getEmpresa();
            ob_start();
            $html = $this->views->getView('ventas', "reporte-credito", $data);
            $html = ob_get_clean();
            require_once 'vendor/autoload.php';
            $mpdf = new \Mpdf\Mpdf();
            if ($data['credito']['estatus'] == 0) {
                $mpdf->SetWatermarkImage('Assets/img/anulado.png');
                $mpdf->showWatermarkImage = true;
            }
            // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
            $mpdf->WriteHTML($html);
            $mpdf->Output();
        } else {
            header('location: ' . base_url . 'creditos');
        }
    }

    public function generarPdf($folio)
    {
        $data['estilo'] = 'reporte.css';
        $data['logo_tamanio'] = 250;
        $data['empresa'] = $this->model->getEmpresa();
        $data['abono'] = $this->model->getAbonoPDF($folio);
        $data['abono_detalle'] = $this->model->getAbonoDetallePDF($folio);
        //$data['sucursal'] = $this->model->getSucursalID($data['abono']['id_usuario']);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $feedUrl);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
        $rawFeed = curl_exec($ch);
        $error   = curl_error($ch);
        curl_close($ch);

        ob_start();

        $html = $this->views->getView('creditoventas', "abono-print", $data);

        $html = ob_get_clean();

        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([
            'format' => [76.2, 160],
            'orientation' => 'P',
            'margin_left' => 5,
            'margin_right' => 5,
            'margin_top' => 5,
            'margin_bottom' => 5
        ]);

        if ($data['abono']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }
       
        $mpdf->WriteHTML($html);
        $mpdf->Output('Abono-'.$folio.'.pdf',"I");
    }    

    /*
    Anterior
    public function generarPdf($folio)
    {
        $data['estilo'] = 'reporte.css';
        $data['logo_tamanio'] = 250;
        $data['empresa'] = $this->model->getEmpresa();
        $data['abono'] = $this->model->getAbonoPDF($folio);
        $data['abono_detalle'] = $this->model->getAbonoDetallePDF($folio);
        $data['sucursal'] = $this->model->getSucursalID($data['abono']['id_usuario']);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $feedUrl);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
        $rawFeed = curl_exec($ch);
        $error   = curl_error($ch);
        curl_close($ch);

        ob_start();

        $html = $this->views->getView('creditoventas', "abono-print", $data);

        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([
            'format' => [76.2, 160],
            'orientation' => 'P',
            'margin_left' => 5,
            'margin_right' => 5,
            'margin_top' => 5,
            'margin_bottom' => 5
        ]);

        if ($data['abono']['estado'] == 0) {
            $mpdf->SetWatermarkImage('Assets/img/anulado.png');
            $mpdf->showWatermarkImage = true;
        }
       
        $mpdf->WriteHTML($html);
        $mpdf->Output('Abono-'.$folio.'.pdf',"I");
    }    */

    /*public function pdfAbono($id)
    {

        $data['abono'] = $this->model->datoAbono($id);
        $data['empresa'] = $this->model->getEmpresa();
        ob_start();
        $html = $this->views->getView('ventas', "ticket-abono", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'format' => [48, 210],
            'margin_left' => 2,
            'margin_right' => 2,
            'margin_top' => 0,
            'margin_bottom' => 0
        ]);
        $mpdf->SetWatermarkImage('Assets/img/logo.png');
        $mpdf->showWatermarkImage = true;
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }*/

    public function buscarCliente()
    {
        $data = $this->model->buscarCliente($_GET['q']);
        $datos = array();
        foreach ($data as $row) {
            $data['id'] = $row['id'];
            $data['label'] = $row['nombre'] . ' - ' . $row['direccion'];
            $data['value'] = $row['nombre'];
            $data['vendedor'] = $row['id_vendedor1'];
            $data['tipoid'] = $row['tipoid'];
            $data['nit'] = $row['nit'];         
            $data['direccion'] = $row['direccion'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }

}
