<?php
class ProductosModel extends Query{
    public function __construct()
    {
        parent::__construct();
    }

    public function getProductos_ss()
    {
        $columns=array('foto','codigo', 'codigo_alter','descripcion','detalles','precio1','precio2','precio3','cantidad','categoria','marca','estado','ultimaventa');
        $columnsSearch=array('codigo','codigo_alter', 'descripcion');

        $limit = $this->getLimitDatatable();
        $order = $this->getOrderDatatable($columns);
        $search = $this->getSearchDatatable($columnsSearch);
        $binds = $this->getBindsDatatable($columnsSearch);

        if($_GET['fecha_desde']!='' && $_GET['fecha_hasta']!='')
        {
            $search.=" AND p.ultimaventa  BETWEEN '{$_GET['fecha_desde']} 00:00:00' AND '{$_GET['fecha_hasta']} 23:59:00' ";
        }
        if($_GET['categoria']!='')
        {
            $search.=" AND p.id_categoria='{$_GET['categoria']}' ";
        }
        if($_GET['marca']!='')
        {
            $search.=" AND p.id_marca='{$_GET['marca']}' ";
        }        

        $sql = "SELECT SQL_CALC_FOUND_ROWS
        foto,
        TRIM(p.codigo) as codigo,
        TRIM(p.codigo_alter) as codigo_alter,
        p.descripcion as descripcion,
        p.detalles as detalles,
        p.precio1 as precio1,
        p.precio2 as precio2,
        p.precio3 as precio3,
        p.cantidad as cantidad,
        IFNULL( (SELECT categoria FROM categorias ca WHERE ca.id = p.id_categoria) , 'SIN CATEGORIA') as categoria,
        IFNULL( (SELECT marca FROM marcas ma WHERE ma.id = p.id_marca) , 'SIN MARCA') as marca,
        p.estado as estado,
        p.ultimaventa as ultimaventa,
        id,
        DATEDIFF(now(),p.ultimaventa) as diasdiferencia

        FROM productos p WHERE 1=1 {$search} {$order} {$limit}";

        $data = $this->selectAllBind($sql,PDO::FETCH_NUM,$binds);

        $TotalRecords = $this->getTotalRecordsDatatable();

		$output = array(
		 	"sEcho" => intval($_GET['sEcho']),
		 	"iTotalRecords" => count($data),
		 	"iTotalDisplayRecords" => $TotalRecords,
		 	"aaData" => $data,
		);
        return $output;
    }

    public function getProductos()
    {
        /*$sql = "
        SELECT ma.marca, c.categoria, me.medida, p.* FROM productos p 
        INNER JOIN marcas ma ON ma.id = p.id_marca 
        INNER JOIN categorias c ON c.id = p.id_categoria 
        INNER JOIN medidas me ON me.id = p.id_medida";
        */
        $sql = "SELECT 
        IFNULL( (SELECT marca FROM marcas ma WHERE ma.id = p.id_marca) , 'SIN MARCA') as marca
        ,IFNULL( (SELECT categoria FROM categorias ca WHERE ca.id = p.id_categoria) , 'SIN CATEGORIA') as categoria
        ,IFNULL( (SELECT medida FROM medidas me WHERE me.id = p.id_medida) , 'SIN MEDIDA') as medida
        ,DATEDIFF(now(),p.ultimaventa) as diasdiferencia,p.* FROM productos p";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getProductosExcel($fecha_min, $fecha_max, $categoria, $marca, $search)
    {
        $csearch = '';
        if($search != '') { $csearch = " AND (p.codigo LIKE '%{$search}%' OR p.codigo_alter LIKE '%{$search}%' OR p.descripcion LIKE '%{$search}%')"; }
        if($fecha_min!='' && $fecha_max!='') { $csearch.=" AND p.ultimaventa  BETWEEN '{$fecha_min} 00:00:00' AND '{$fecha_max} 23:59:00' "; }
        if($categoria!='') { $csearch.=" AND p.id_categoria='{$categoria}' "; }
        if($marca!='') { $csearch.=" AND p.id_marca='{$marca}' "; }  

        $sql = "SELECT 
        IFNULL( (SELECT marca FROM marcas ma WHERE ma.id = p.id_marca) , 'SIN MARCA') as marca
        ,IFNULL( (SELECT categoria FROM categorias ca WHERE ca.id = p.id_categoria) , 'SIN CATEGORIA') as categoria
        ,IFNULL( (SELECT medida FROM medidas me WHERE me.id = p.id_medida) , 'SIN MEDIDA') as medida
        ,DATEDIFF(now(),p.ultimaventa) as diasdiferencia,p.* FROM productos p WHERE 1=1 {$csearch}";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getDatos(string $table)
    {
        $sql = "SELECT * FROM $table WHERE estado = 1";
        $data = $this->selectAll($sql);
        return $data;
    }



    //public function registrarProducto(string $codigo, string $nombre, string $precio_compra, string $precio_venta, int $minimo, int $medidas, int $categorias, int $marcas, string $img)
    public function registrarProducto(
        string $codigo,
        string $img,
        string $ubicacion,
        string $observaciones,
        string $minimo,
        string $maximo,
        string $precio_compra,
        string $precio_venta,
        string $precio1,
        string $precio2,
        string $precio3,
        string $precio4,
        string $precio5,
        string $estado,
        string $imprime,
        string $codigo_alter,
        string $codigo_proveedor,
        string $descripcion,
        string $detalles,
        string $clasificacion,
        string $tipo,
        string $proveedor,
        string $medidas,
        string $categorias,
        string $marcas
    )
    {
        $verificar = "SELECT * FROM productos WHERE codigo = '$codigo'";
        $existe = $this->select($verificar);
        if (empty($existe)) {
            $sql = "INSERT INTO productos(
                codigo, 
                foto, 
                ubicacion,
                observaciones,
                stock_minimo,
                stock_maximo,
                precio_compra,
                precio_venta,
                precio1,
                precio2,
                precio3,
                precio4,
                precio5,
                estado,
                imprime,
                codigo_alter,
                codigo_proveedor,
                descripcion,
                detalles,
                clasificacion,
                tipo,
                id_proveedor,
                id_medida,
                id_categoria,
                id_marca
                ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            $datos = array(
                $codigo,
                $img,
                $ubicacion,
                $observaciones,
                $minimo,
                $maximo,
                $precio_compra,
                $precio_venta,
                $precio1,
                $precio2,
                $precio3,
                $precio4,
                $precio5,
                $estado,
                $imprime,
                $codigo_alter,
                $codigo_proveedor,
                $descripcion,
                $detalles,
                $clasificacion,
                ($tipo=='')?NULL:$tipo,
                ($proveedor=='')?NULL:$proveedor,
                ($medidas=='')?NULL:$medidas,
                ($categorias=='')?NULL:$categorias,
                ($marcas=='')?NULL:$marcas           
            );
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "ok";
            }else{
                $res = "error";
            }
        }else{
            $res = "existe";
        }
        return $res;
    }
    public function modificarProducto(
        string $codigo,
        string $img,
        int $id,
        string $ubicacion,
        string $observaciones,
        string $minimo,
        string $maximo,
        string $precio_compra,
        string $precio_venta,
        string $precio1,
        string $precio2,
        string $precio3,
        string $precio4,
        string $precio5,
        string $estado,
        string $imprime,
        string $codigo_alter,
        string $codigo_proveedor,
        string $descripcion,
        string $detalles,
        string $clasificacion,
        string $tipo,
        string $proveedor,
        string $medidas,
        string $categorias,
        string $marcas              
    )
    {
        $verificar = "SELECT * FROM productos WHERE codigo = '$codigo' AND id != $id";
        $existe = $this->select($verificar);
        if (empty($existe)) {
            $sql = "UPDATE productos SET 
                codigo=?, 
                foto=?, 
                ubicacion=?,
                observaciones=?,
                stock_minimo=?,
                stock_maximo=?,
                precio_compra=?,
                precio_venta=?,
                precio1=?,
                precio2=?,
                precio3=?,
                precio4=?,
                precio5=?,
                estado=?,
                imprime=?,
                codigo_alter=?,
                codigo_proveedor=?,
                descripcion=?,
                detalles=?,
                clasificacion=?,
                tipo=?,
                id_proveedor=?,
                id_medida=?,
                id_categoria=?,
                id_marca=?         
                WHERE id = ?";
            $datos = array(
                $codigo,
                $img,
                $ubicacion,
                $observaciones,
                $minimo,
                $maximo,
                $precio_compra,
                $precio_venta,
                $precio1,
                $precio2,
                $precio3,
                $precio4,
                $precio5,
                $estado,
                $imprime,
                $codigo_alter,
                $codigo_proveedor,
                $descripcion,
                $detalles,
                $clasificacion,
                ($tipo=='')?NULL:$tipo,
                ($proveedor=='')?NULL:$proveedor,
                ($medidas=='')?NULL:$medidas,
                ($categorias=='')?NULL:$categorias,
                ($marcas=='')?NULL:$marcas,
                $id
            );
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "modificado";
            } else {
                $res = "error";
            }
        }else{
            $res = "existe";
        }
        return $res;
    }
    public function editarPro(int $id)
    {
        $sql = "SELECT * FROM productos WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }

    public function editarProducto(int $id)
    {
        $sql = "SELECT *,
            IFNULL( (SELECT categoria FROM categorias ca WHERE ca.id = p.id_categoria) , 'SIN CATEGORIA') as categoria,
            IFNULL( (SELECT marca FROM marcas ma WHERE ma.id = p.id_marca) , 'SIN MARCA') as marca        
         FROM productos p WHERE codigo = $id";

        $data = $this->select($sql);
        return $data;
    }

    public function accionPro(int $estado, int $id)
    {
        $sql = "UPDATE productos SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        return $data;
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    public function getProductosReporte($fecha_min, $fecha_max, $categoria, $marca, $search)
    {
        $csearch = '';
        if($search != '') { $csearch = " AND (p.codigo LIKE '%{$search}%' OR p.codigo_alter LIKE '%{$search}%' OR p.descripcion LIKE '%{$search}%')"; }
        if($fecha_min!='' && $fecha_max!='') { $csearch.=" AND p.ultimaventa  BETWEEN '{$fecha_min} 00:00:00' AND '{$fecha_max} 23:59:00' "; }
        if($categoria!='') { $csearch.=" AND p.id_categoria='{$categoria}' "; }
        if($marca!='') { $csearch.=" AND p.id_marca='{$marca}' "; }  

        $sql = "SELECT 
        IFNULL( (SELECT marca FROM marcas ma WHERE ma.id = p.id_marca) , 'SIN MARCA') as marca
        ,IFNULL( (SELECT categoria FROM categorias ca WHERE ca.id = p.id_categoria) , 'SIN CATEGORIA') as categoria
        ,IFNULL( (SELECT medida FROM medidas me WHERE me.id = p.id_medida) , 'SIN MEDIDA') as medida
        ,p.* FROM productos p WHERE 1=1 {$csearch}";        
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getProductosReporteCat($fecha_min, $fecha_max, $categoria, $marca, $search)
    {
        $csearch = '';
        if($search != '') { $csearch = " AND (p.codigo LIKE '%{$search}%' OR p.codigo_alter LIKE '%{$search}%' OR p.descripcion LIKE '%{$search}%')"; }
        if($fecha_min!='' && $fecha_max!='') { $csearch.=" AND p.ultimaventa  BETWEEN '{$fecha_min} 00:00:00' AND '{$fecha_max} 23:59:00' "; }
        if($categoria!='') { $csearch.=" AND p.id_categoria='{$categoria}' "; }
        if($marca!='') { $csearch.=" AND p.id_marca='{$marca}' "; }  

        $sql = "SELECT 
        IFNULL( (SELECT marca FROM marcas ma WHERE ma.id = p.id_marca) , 'SIN MARCA') as marca
        ,IFNULL( (SELECT categoria FROM categorias ca WHERE ca.id = p.id_categoria) , 'SIN CATEGORIA') as categoria
        ,IFNULL( (SELECT medida FROM medidas me WHERE me.id = p.id_medida) , 'SIN MEDIDA') as medida
        ,TRIM(codigo) as codigo
        ,TRIM(codigo_alter) as codigo_alter
        ,TRIM(descripcion) as descripcion
        ,foto
        FROM productos p WHERE imprime=1 {$csearch}";        
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getProductosKardex($id)
    {
        //$sql = "SELECT ma.marca, c.categoria, me.medida, p.* FROM productos p INNER JOIN marcas ma ON ma.id = p.id_marca INNER JOIN categorias c ON c.id = p.id_categoria INNER JOIN medidas me ON me.id = p.id_medida WHERE p.estado = 1";
        $sql = "(SELECT 
                `compras`.`fecha` as FECHA,
                `compras`.`hora` as HORA,
                'COMPRA' as TIPO,
                `compras`.`id_proveedor` as IDREFERENCIA,
                (SELECT `proveedor`.`nombre` FROM `proveedor` WHERE `compras`.`id_proveedor`=`proveedor`.`id`) as REFERENCIA,
                `compras`.`id` as DOCUMENTO,
                `detalle_compra`.`cantidad` as CANTIDAD
                FROM `detalle_compra`,`compras` WHERE `detalle_compra`.`folio`=`compras`.`id` AND `detalle_compra`.`id_producto`='{$id}')
                UNION
                (SELECT 
                `ventas`.`fecha` as FECHA,
                `ventas`.`hora` as HORA,
                'VENTA' as TIPO,
                `ventas`.`id_cliente` as IDREFERENCIA,
                `ventas`.`nomcliente` as REFERENCIA,
                `ventas`.`id` as DOCUMENTO,
                `detalle_ventas`.`cantidad` as CANTIDAD
                FROM `detalle_ventas`,`ventas` WHERE `detalle_ventas`.`folio`=`ventas`.`id` AND `detalle_ventas`.`id_producto`='{$id}' AND `ventas`.`estado`!=0)
                ORDER BY FECHA, HORA";        
        $data = $this->selectAll($sql);
        return $data;
    }    
}
