<?php
class VendedoresModel extends Query{

    public function __construct()
    {
        parent::__construct();
    }

    public function getVendedores()
    {
        //$sql = "SELECT *,DATE_FORMAT(ultimaventa,'%d/%m/%Y') as ultimaventa FROM vendedores";
        $sql = "SELECT *,DATEDIFF(now(),ultimaventa) as diasdiferencia FROM vendedores";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }

    public function getVendedores2()
    {
        $sql = "SELECT codven, nombre FROM vendedores";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getVendedor($id)
    {
        $sql = "SELECT codven, nombre FROM vendedores WHERE id='{$id}'";
        $data = $this->select($sql);
        return $data;
    }

    public function getReporteCuentasCobrar($id)
    {
        $sql = "SELECT 
                IFNULL((SELECT nombre FROM `clientes` WHERE clientes.id=creditos.cliente), 'MOSTRADOR') AS CLIENTE,
                IF(cliente=0, 1, cliente) AS IDCLIENTE,        
                venta as FACTURA,
                fecha as FECHA,
                monto as VALOR,
                abonado as ABONO,
                (monto - abonado) as SALDO,
                DATEDIFF(NOW(), fecha) AS DIAS_DE_ATRASO
                FROM `creditos`
                WHERE id_usuario='".addslashes($id)."'
                AND (monto - abonado) > 0
                ORDER BY IDCLIENTE,FACTURA ASC";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getReporteAntiguedadSaldos($id)
    {
        $sql = "SELECT
				IFNULL((SELECT nombre FROM `clientes` WHERE clientes.id=creditos.cliente), 'MOSTRADOR') AS CLIENTE,
                IF(cliente=0, 1, cliente) AS IDCLIENTE,
                venta as FACTURA,
                fecha as FECHA,
                DATE_ADD(fecha, INTERVAL 30 DAY) as VENCE,
                monto as VALOR,
                abonado as ABONO,
                (monto - abonado) as SALDO,
                DATEDIFF(NOW(), fecha) AS DIAS_DE_ATRASO,
                IF(DATEDIFF(NOW(), fecha)<=30, (monto - abonado), 0) as '30',
                IF(DATEDIFF(NOW(), fecha)>30 && DATEDIFF(NOW(), fecha)<=60, (monto - abonado), 0) as '60',
                IF(DATEDIFF(NOW(), fecha)>60, (monto - abonado), 0) as '90'
                FROM `creditos`
                WHERE id_usuario='".addslashes($id)."'
                AND (monto - abonado) > 0
                ORDER BY IDCLIENTE,FACTURA ASC";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getReporteEstadoCuenta($id)
    {
        
        $sql = "(SELECT 
                venta as DOCUMENTO,
                ,venta as ORDERDOCUMENTO
                ,fecha as FECHA
                ,monto as CARGO
                ,0 as ABONO
                ,'' as REFERENCIA
                FROM `creditos` WHERE cliente='".addslashes($id)."')
                UNION 
                (SELECT
                (SELECT concat(creditos.venta,' - R.',abonos.id) FROM `creditos` WHERE creditos.id=abonos.id_credito LIMIT 1) as DOCUMENTO,
                ,(SELECT venta FROM `creditos` WHERE creditos.id=abonos.id_credito LIMIT 1) as ORDERDOCUMENTO
                ,fecha_abono as FECHA
                ,0 as CARGO
                ,monto * -1 as ABONO
                , CONCAT(metodo_pago,' | ',observaciones,' | ',referencias) as REFERENCIA
                FROM `abonos` WHERE id_cliente='".addslashes($id)."')
                ORDER BY IDCLIENTE,ORDERDOCUMENTO, FECHA LIMIT 100";
        $data = $this->selectAll($sql);
        return $data;
    }    


    

    public function getPaises()
    {
        $sql = "SELECT cod, pais FROM paises";
        $data = $this->selectAll($sql);
        return $data;
    }
    
    public function registrarVendedor(string $nombre, int $tipoid,string $nit, string $telefono, string $mensajeria, string $direccion, string $municipio, string $departamento, string $pais, string $coordenadas, float $limite_credito, int $dias_credito, int $id_vendedor1, int $tipocliente, string $contacto, string $telcontacto, string $observaciones)
    {
        $verficar = "SELECT * FROM vendedores WHERE nombre = '$nombre'";
        $existe = $this->select($verficar);
        if (empty($existe)) {
            $sql = "INSERT INTO vendedores(nombre, tipoid, nit, telefono, mensajeria, direccion, municipio, departamento, pais, coordenadas, limite_credito, dias_credito, id_vendedor1, tipocliente ,contacto, telcontacto, observaciones) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            $datos = array($nombre, $tipoid, $nit, $telefono, $mensajeria, $direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones);
            $data = $this->save($sql, $datos);
            if ($data == 1) {
                $res = "ok";
            }else{
                $res = "error";
            }
        }else{
            $res = "existe";
        }
        return $res;
    }


    public function modificarVendedor(string $nombre, int $tipoid, string $nit, string $telefono, string $mensajeria, string $direccion, string $municipio, string $departamento, string $pais, string $coordenadas, float $limite_credito, int $dias_credito, int $id_vendedor1, int $tipocliente, string $contacto, string $telcontacto, string $observaciones, int $id)
    {
        $sql = "UPDATE vendedores SET nombre = ?, tipoid = ?, nit = ? ,telefono = ? ,mensajeria = ? ,direccion = ? ,municipio = ? ,departamento = ? ,pais = ? ,coordenadas = ? ,limite_credito = ? ,dias_credito = ?, id_vendedor1 = ?, tipocliente = ?, contacto = ?, telcontacto = ?, observaciones = ? WHERE id = ?";
        $datos = array($nombre, $tipoid, $nit, $telefono ,$mensajeria ,$direccion, $municipio, $departamento, $pais, $coordenadas, $limite_credito, $dias_credito, $id_vendedor1, $tipocliente, $contacto, $telcontacto, $observaciones, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function modificarAnotaciones(string $observaciones, int $id)
    {
        $sql = "UPDATE vendedores SET observaciones = ? WHERE id = ?";
        $datos = array($observaciones, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function editarVen(int $id)
    {
        $sql = "SELECT * FROM vendedores WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }

    public function accionVen(int $estado, int $id)
    {
        $sql = "UPDATE vendedores SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        return $data;
    }

    public function buscarVendedor(string $nombre)
    {
        $sql = "SELECT * FROM vendedores WHERE nombre LIKE '%" . $nombre . "%' AND estado = 1 LIMIT 10";
        $data = $this->selectAll($sql);
        return $data;
    }
}
