<?php include "Views/templates/headernomenu.php"; ?>

<style>
.chartwidth {
    width:33.3%;
}

@media (max-width: 991.98px) { 
    .chartwidth { width:100%; }
}

@media print {
    .shadow-lg { box-shadow:none !important; }
    .d-print-none { box-shadow:none !important; }
    .chartwidth { width:100%; }

    /*canvas {
        min-height: 100%;
        max-width: 100%;
        max-height: 100%;
        height: 200px!important;
        width: 100%!important;
    } */   

}
</style>

<script>
    <?php
        if(isset($data['idcliente'])) { echo "let idcliente={$data['idcliente']}"; } else { echo "let idcliente=false"; }
    ?>

function beforePrint () {
  for (const id in Chart.instances) {
    Chart.instances[id].resize()
  }
}

if (window.matchMedia) {
  let mediaQueryList = window.matchMedia('print')
  mediaQueryList.addListener((mql) => {
    if (mql.matches) {
      beforePrint()
    }
  })
}

window.onbeforeprint = beforePrint

</script>

<div class="card shadow-lg" >
    
    <div class="card-header border-default fw-bold ">
        Reportes Cliente <strong id='nombreCliente'></strong></span>
    </div>    
    <div class="card-body">
        <div class="row">
            <div class="col-12 form-inline mb-1 d-print-none">
                <select id="yearCharts" class="form-control form-control-sm align-middle">
                    <?php
                    $fecha = date('Y');
                    for ($i = 2021; $i <= $fecha; $i++) { ?>
                    <option value="<?php echo $i; ?>" <?php echo ($i == $fecha) ? 'selected' : ''; ?>><?php echo $i; ?></option>
                    <?php } ?>
                </select>
                <button class='btn btn-success btn-sm ml-2' onclick="iniciarReportes()"><i class="fas fa-sync-alt"></i> Actualizar</button>
            </div>


            <div class="col-12 col-lg-4 p-3">
                <table class='table table-sm table-striped'>
                    <thead class="thead-dark">
                        <tr class=''>
                            <th scope="col" >LINEA</th>
                            <th scope="col" >DESCRIPCION</th>
                            <th scope="col" >VENTAS</th>
                        </tr>
                    </thead>
                        <tbody>
                        <tr>
                            <td>GC</td>
                            <td>ADITAMENTOS</td>
                            <td>Q. 65,653.00</td>
                        </tr>
                        <tr>
                            <td>HR</td>
                            <td>HERRAMIENTAS</td>
                            <td>Q. 54,000.00</td>
                        </tr>
                        <tr>
                            <td>RE</td>
                            <td>REPUESTOS</td>
                            <td>Q. 33,467.87</td>
                        </tr>
                        </tbody>
                </table>
            </div>

            <div class="col-12 col-lg-4 p-3">
                <table class='table table-sm table-striped'>
                    <thead class="thead-dark">
                        <tr class=''>
                            <th scope="col" class=''>CODIGO</th>
                            <th scope="col" class='text-right'>LINEA</th>
                            <th scope="col" class='text-right'>DESCRIPCION</th>
                            <th scope="col" class='text-right'>UNIDADES</th>
                            <th scope="col" class='text-right'>VENTA</th>                            
                        </tr>
                    </thead>

                    <tbody>
                        <tr>
                            <td>13786781</td>
                            <td>AD</td>
                            <td>ESPIGA TIPO Y HULE REFORZADA</td>                            
                            <td>79</td>                            
                            <td>Q. 5,653.00</td>
                        </tr>
                        <tr>
                            <td>HR-35552G</td>
                            <td>HR</td>
                            <td>LLAVE TIPO H DOBLE USO #12</td>                            
                            <td>40</td>
                            <td>Q. 4,000.00</td>
                        </tr>
                        <tr>
                            <td>27562-34555L</td>
                            <td>RE</td>
                            <td>CABEZA EN V PARA MOTOR DOBLE H</td>                            
                            <td>37</td>
                            <td>Q. 3,467.87</td>
                        </tr>
                        <tr>
                            <td>27ERR562-34555L</td>
                            <td>RE</td>
                            <td>CABEZA EN H PARA MOTOR SIMPLE</td>
                            <td>35</td>
                            <td>Q. 1,467.87</td>
                        </tr>
                        <tr>
                            <td>34555L</td>
                            <td>RE</td>
                            <td>PUNTA DIRECCIONAL INFERIOR IZQUIERDA</td>
                            <td>7</td>
                            <td>Q. 467.87</td>
                        </tr>
                        <tr>
                            <td>275DF62</td>
                            <td>RE</td>
                            <td>MOTOR AUXILIAR POLARIZADO</td>
                            <td>1</td>
                            <td>Q. 267.87</td>
                        </tr>


                    </tbody>


                </table>
            </div>




        </div>        
    </div>
</div>

<?php include "Views/templates/footernomenu.php"; ?>
