<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
                <hr>
                <p><b>Ruc:</b> <?php echo $data['empresa']['identidad']; ?></p>
                <p><b>Teléfono:</b> <?php echo $data['empresa']['telefono']; ?></p>
                <p><b>Dirección:</b> <?php echo $data['empresa']['direccion']; ?></p>
            </td>
            <td class="info-detalle">
                <p><b>Credito N°:</b> <?php echo $data['credito']['id']; ?></p>
                <a href="<?php echo base_url . 'compras/generarPdf/' . $data['credito']['compra']; ?>" target="_blank"><b>Compra N°:</b> <?php echo $data['credito']['compra']; ?></a>
                <p>Fecha: <?php echo $data['credito']['fecha']; ?></p>
            </td>
        </tr>
    </table>


    <h5 class="title">Datos del Proveedor</h5>
    <table id="container-info">
        <tr>
            <td colspan="2">
                <strong>Nombre: </strong>
                <p><?php echo $data['credito']['nombre']; ?></p>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Teléfono: </strong>
                <p><?php echo $data['credito']['telefono']; ?></p>
            </td>
            <td>
                <strong>Dirección: </strong>
                <p><?php echo $data['credito']['direccion']; ?></p>
            </td>
        </tr>
    </table>
    <h5 class="title">Detalle de abonos</h5>
    <table id="container-producto">
        <thead>
            <tr>
                <th class="text-left">Abono</th>
                <th class="text-left">Fecha</th>
                <th class="text-right">Restante</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($data['abonos'] as $abono) { ?>
                <tr>
                    <td><?php echo number_format($abono['abono'], 2); ?></td>
                    <td><?php echo $abono['fecha']; ?></td>
                    <td class="text-right"><?php echo number_format($abono['monto'] - $abono['abono'], 2); ?></td>
                </tr>
            <?php } ?>
            <tr class="total">
                <td class="text-right" colspan="2">Total</td>
                <td class="text-right"><?php echo number_format($data['credito']['monto'], 2); ?></td>
            </tr>
        </tbody>
    </table>
    <div class="mensaje">
        <?php echo $data['empresa']['mensaje']; ?>
        <hr>
        <a class="text-right" target="_blank"><b><?php echo base_url . 'compras/generarPdf/' . $data['credito']['compra']; ?></a>
    </div>

</body>

</html>