<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
                <hr>
                <p><b>Nit:</b> <?php echo $data['empresa']['identidad']; ?></p>
                <p><b>Teléfono:</b> <?php echo $data['empresa']['telefono']; ?></p>
                <p><b>Dirección:</b> <?php echo $data['empresa']['direccion']; ?></p>
            </td>
            <td class="info-detalle">
                <h4>Cotizacion</h4>
                <p>N°: <strong><?php echo $data['cotizacion']['id']; ?></strong></p>
                <p>Fecha: <?php echo $data['cotizacion']['fecha']; ?></p>
                <p>Hora: <?php echo $data['cotizacion']['hora']; ?></p>
            </td>
        </tr>
    </table>


    <h5 class="title">DATOS DEL CLIENTE</h5>

    <div id="container-info">
    <table>
        <tr>
            <td colspan="2">
                <strong>Nombre: </strong>
                <p><?php echo $data['cotizacion']['nombre'] ?></p>
            </td>
        </tr>
        <tr>
            <td>
                <strong>Teléfono: </strong>
                <p><?php echo $data['cotizacion']['telefono'] ?></p>
            </td>
            <td>
                <strong>Dirección: </strong>
                <p><?php echo $data['cotizacion']['direccion'] ?></p>
            </td>
        </tr>
    </table>
    </div>


    <h5 class="title">Detalle de los Productos</h5>
    <table id="container-producto">
        <thead>
            <tr>
                <th width='20%' class="text-left">Cant</th>
                <th width='50%' class="text-left">Descripción</th>
                <th width='15%' class="text-right">Precio</th>
                <th width='15%' class="text-right">SubTotal</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $descuento = 0;
            foreach ($data['detalle'] as $producto) {
                $descuento += $producto['descuento']; ?>
                <tr>
                    <td width='20%'><?php echo $producto['cantidad']; ?></td>
                    <td width='50%'><?php echo $producto['descripcion']; ?></td>
                    <td width='15%' class="text-right"><?php echo number_format($producto['precio'], 2); ?></td>
                    <td width='15%' class="text-right"><?php echo number_format($producto['cantidad'] * $producto['precio'], 2); ?></td>
                </tr>
            <?php } ?>
            </tbody>
            </table>
        

            <hr>

            <table>
            <tbody>

            <tr class="total">
                <td width='20%'></td>
                <td width='50%'></td>
                <td width='15%' class="text-right" colspan="1"><strong>Descuento</strong></td>
                <td width='15%' class="text-right"><strong><?php echo number_format($descuento, 2); ?></strong></td>
            </tr>
            <tr class="total">
                <td width='20%'></td>
                <td width='50%'></td>
                <td width='15%' class="text-right" colspan="1"><strong>Total</strong></td>
                <td width='15%' class="text-right"><strong><?php echo number_format($data['cotizacion']['total'], 2); ?></strong></td>
            </tr>

            </tbody>
            </table>


    <div class="mensaje">
        <?php echo $data['empresa']['mensaje']; ?>
        <hr style='margin-bottom:5px;'>
        <?php echo nl2br($data['cotizacion']['nota']); ?>
    </div>
</body>

</html>
