<?php
class Cajas extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }
    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'pages/cajas.js')
        );
        $this->views->getView('cajas', "index", $data);
    }
    public function listar()
    {
        $data = $this->model->getCajas();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]['estado'] == 1) {
                $data[$i]['editar'] = '<button class="btn btn-primary" type="button" onclick="btnEditarCaja(' . $data[$i]['id'] . ');"><i class="fas fa-edit"></i></button>';
                $data[$i]['eliminar'] = '<button class="btn btn-danger" type="button" onclick="btnEliminarCaja(' . $data[$i]['id'] . ');"><i class="fas fa-trash-alt"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-success">Activo</span>';
            } else {
                $data[$i]['editar'] = '';
                $data[$i]['eliminar'] = '<button class="btn btn-success" type="button" onclick="btnReingresarCaja(' . $data[$i]['id'] . ');"><i class="fas fa-circle"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-danger">Inactivo</span>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function registrar()
    {
        $caja = strClean($_POST['caja']);
        $id = strClean($_POST['id']);
        if (empty($caja)) {
            $msg = array('msg' => 'La caja es requerido', 'icono' => 'error');
        } else {
            if ($id == "") {
                $data = $this->model->registrarCaja($caja);
                if ($data == "ok") {
                    $msg = array('msg' => 'Caja registrado', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'La caja ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar la caja', 'icono' => 'error');
                }
            } else {
                $data = $this->model->modificarCaja($caja, $id);
                if ($data == "modificado") {
                    $msg = array('msg' => 'Caja modificado con éxito', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al modificar la caja', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function editar($id)
    {
        if (is_numeric($id)) {
            $data = $this->model->editarCaja($id);
        } else {
            header('location: ' . base_url . 'cajas');
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function eliminar($id)
    {
        $data = $this->model->accionCaja(0, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Caja dado de baja', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar la caja', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function reingresar($id)
    {
        $data = $this->model->accionCaja(1, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Caja reingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al reingresar la caja', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function cierre()
    {
        $data['scripts'] = array(
            array('script' => 'sum().js'),
            array('script' => 'pages/apertura.js')
        );
        $this->views->getView('cajas', "cierre", $data);
    }
    public function listar_apertura()
    {
        $data = $this->model->getApertura('cajas_cierre', $this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['reporte'] = '<a class="btn btn-danger" target="_blank" href="' . base_url . 'cajas/cajaPdf/' . $data[$i]['id'] . '"><i class="fas fa-file-pdf"></i></a>';
            if ($data[$i]['estado'] == 1) {
                $data[$i]['estado'] = '<span class="badge badge-warning">Abierto</span>';
            } else {
                $data[$i]['estado'] = '<span class="badge badge-success">Cerrado</span>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function registrarCierre()
    {
        $monto_inicial = strClean($_POST['monto_inicial']);
        $id_user = $this->id_usuario;
        $id_caja = $_SESSION['id_caja'];
        $fecha = date('Y-m-d H:i:s');
        if (empty($monto_inicial)) {
            $mensaje = array('msg' => 'Ingrese el monto inicial', 'icono' => 'warning');
        } else {
            $data = $this->model->registrarCierre($id_user, $id_caja, $fecha, $monto_inicial);
            if ($data == 'ok') {
                $mensaje = array('msg' => 'Caja abierto con éxito', 'icono' => 'success');
            } else if ($data == 'existe') {
                $mensaje = array('msg' => 'La caja ya esta abierta',  'icono' => 'warning');
            } else {
                $mensaje = array('msg' => 'Error al abrir la caja', 'icono' => 'error');
            }
        }
        echo json_encode($mensaje, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function registrar_movimiento()
    {
        $accion = $_POST['accion'];
        $monto = $_POST['monto'];
        $desc = $_POST['descripcion'];
        $id_user = $this->id_usuario;
        $fecha = date('Y-m-d');
        $hora = date('H:i:s');
        if (empty($monto) || empty($desc)) {
            $msg = array('msg' => 'Todo los campos con * son requeridos', 'icono' => 'warning');
        } else {
            if (!empty($accion)) {
                if ($accion === 'devolucion_caja') {
                    $data = $this->model->registrarDevolucion($accion, $monto, $desc, $id_user, $fecha, $hora);
                } else {
                    $data = $this->model->registrarMovimiento($accion, $monto, $desc, $id_user, $fecha, $hora);
                }
                if ($data == "ok") {
                    $msg = array('msg' => 'Movimiento Registrado con éxito', 'icono' => 'success');
                } else if ($data == 'no') {
                    $msg = array('msg' => 'No hay dinero suficiente en la caja', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar el movimiento', 'icono' => 'error');
                }
            } else {
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function cerrarCaja()
    {
        $data = $this->datos();
        if ($data['saldo'] < 1) {
            $msg = array('msg' => 'No puedes cerrar la caja sin monto', 'icono' => 'error');
        } else {
            $date = date('Y-m-d H:i:s');
            $datos = $this->datos();
            $total = $this->model->getTotalVentas($this->id_usuario);
            $result = $this->model->cerrarCaja($date, $data['saldo'], $data['total'], $total['total'], $datos['prestamo'], $datos['devolucion'], $datos['gasto'], $datos['monto'], $this->id_usuario);
            if ($result == 'ok') {
                $this->model->apertura('ventas', $this->id_usuario);
                $this->model->apertura('abonos', $this->id_usuario);
                $this->model->cerrarAcciones('prestamo_caja', 0, $this->id_usuario);
                $this->model->cerrarAcciones('gasto_caja', 0, $this->id_usuario);
                $this->model->cerrarAcciones('devolucion_caja', 0, $this->id_usuario);
                $msg = array('msg' => 'Caja Cerrada con exito', 0, 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al cerrar la caja', 'icono' => 'error');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function movimiento($titulo)
    {
        $data['titulo'] = $titulo;
        $data['verificar'] = $this->model->getCajaCierre($this->id_usuario);
        $data['scripts'] = array(
            array('script' => 'chart.min.js'),
            array('script' => 'pages/movimientos.js')
        );
        $this->views->getView('cajas', "movimiento", $data);
    }
    public function listar_prestamos()
    {
        $data = $this->model->getApertura('prestamo_caja', $this->id_usuario);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function listar_gastos()
    {
        $data = $this->model->getApertura('gasto_caja', $this->id_usuario);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function listar_devolucion()
    {
        $data = $this->model->getApertura('devolucion_caja', $this->id_usuario);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function grafico_movimiento()
    {
        $data = $this->datos();
        $data['moneda'] = moneda;
        $data['montoCaja'] = number_format($data['saldo'], 2);
        $data['saldoTotal'] = number_format($data['datos'] + $data['saldo'], 2);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function datos()
    {
        $data['empresa'] = $this->model->getEmpresa();
        $monto = $this->model->getMontoFinal($this->id_usuario);
        $monto_final = (!empty($monto['monto_final'])) ? $monto['monto_final'] : 0;
        $devolucion = $this->model->getAcciones('devolucion_caja', $this->id_usuario);
        $prestamo = $this->model->getAcciones('prestamo_caja', $this->id_usuario);
        $gasto = $this->model->getAcciones('gasto_caja', $this->id_usuario);
        $datos = $this->model->getCajaCierre($this->id_usuario);
        $credito = $this->model->getMontoCredito($this->id_usuario);
        $apartados = $this->model->getApartados($this->id_usuario);
        $data['gasto'] = (!empty($gasto['total'])) ? $gasto['total'] : 0.00;
        $data['prestamo'] = (!empty($prestamo['total'])) ? $prestamo['total'] : 0.00;
        $data['datos'] = (!empty($datos['monto_inicial'])) ? $datos['monto_inicial'] : 0.00;
        $data['devolucion'] = (!empty($devolucion['total'])) ? $devolucion['total'] : 0.00;
        $data['monto'] = $monto_final + $credito['total'] + $apartados['total'];
        $data['egresos'] = $data['prestamo'] + $data['gasto'];
        $data['saldo'] = ($data['monto'] - $data['egresos']) + $data['devolucion'];
        $data['total'] = $data['saldo'] + $data['datos'];

        return $data;
    }
    public function reportePdf()
    {
        $data = $this->datos();
        $data['caja'] = $this->model->editarCaja($_SESSION['id_caja']);
        ob_start();
        $html = $this->views->getView('cajas', "reporte", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        $mpdf->SetWatermarkImage('Assets/img/logo.png');
        $mpdf->showWatermarkImage = true;
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
    public function cajaPdf($id)
    {
        $caja = $this->model->monto_inicial($id);
        $data['gasto'] = $caja['gastos'];
        $data['monto'] = $caja['ingresos'];
        $data['egresos'] = $caja['prestamos'] + $caja['gastos'];
        $data['prestamo'] = $caja['prestamos'];
        $data['devolucion'] = $caja['devolucion'];
        $data['datos'] = $caja['monto_inicial'];
        $data['saldo'] = ($data['monto'] - $data['egresos']) + $data['devolucion'];
        $data['empresa'] = $this->model->getEmpresa();
        $data['caja'] = $this->model->editarCaja($id);
        ob_start();
        $html = $this->views->getView('cajas', "reporte", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        $mpdf->SetWatermarkImage('Assets/img/logo.png');
        $mpdf->showWatermarkImage = true;
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }
}
