<?php
class Categorias extends Controller
{
    private $id_usuario;

    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'pages/categorias.js')
        );
        $this->views->getView('productos', "categorias", $data);
    }

    public function listar()
    {
        $data = $this->model->getCategorias();
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['editar'] = '';
            if ($data[$i]['estado'] == 1) {
                $data[$i]['editar'] = '<button class="btn btn-primary" type="button" onclick="btnEditarCat(' . $data[$i]['id'] . ');"><i class="fas fa-edit"></i></button>';
                $data[$i]['eliminar'] = '<button class="btn btn-danger" type="button" onclick="btnEliminarCat(' . $data[$i]['id'] . ');"><i class="fas fa-trash-alt"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-success">Activo</span>';
                $data[$i]['estado_txt'] = 'activo';
            } else {
                $data[$i]['eliminar'] = '<button class="btn btn-success" type="button" onclick="btnReingresarCat(' . $data[$i]['id'] . ');"><i class="fas fa-circle"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-danger">Inactivo</span>';
                $data[$i]['estado_txt'] = 'inactivo';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function registrar()
    {
        $categoria = strClean($_POST['categoria']);
        $id = strClean($_POST['id']);
        if (empty($categoria)) {
            $msg = array('msg' => 'La categoria es requerido', 'icono' => 'error');
        } else {
            if ($id == "") {
                $data = $this->model->registrarCat($categoria);
                if ($data == "ok") {
                    $msg = array('msg' => 'Categoria registrado', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'La Categoria ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar la Categoria', 'icono' => 'error');
                }
            } else {
                $data = $this->model->modificarCat($categoria, $id);
                if ($data == "modificado") {
                    $msg = array('msg' => 'Categoria modificado con éxito', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al modificar la Categoria', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editar($id)
    {
        $data = $this->model->editarCat($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function eliminar($id)
    {
        $data = $this->model->accionCat(0, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Categoria dado de baja', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar la Categoria', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function reingresar($id)
    {
        $data = $this->model->accionCat(1, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Categoria reingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al reingresar la Categoria', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
}
