<?php

use Luecano\NumeroALetras\NumeroALetras;

class Cotizaciones extends Controller
{
    private $id_usuario;

    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'jquery-ui.min.js'),
            array('script' => 'pages/cotizaciones.js')
        );
        $this->views->getView('cotizaciones', "index", $data);
    }

    public function buscarProducto()
    {
        $data = $this->model->buscarProducto(strClean($_GET['pro']));
        $datos = array();
        foreach ($data as $row) {
            $data['id'] = $row['id'];
            $data['label'] = $row['codigo'] . ' - ' . $row['descripcion'];
            $data['value'] = $row['codigo'];
            $data['precio'] = $row['precio_venta'];
            $data['descripcion'] = $row['descripcion'];
            array_push($datos, $data);
        }
        echo json_encode($datos, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function listar()
    {
        $data['detalle'] = $this->model->getDetalle($this->id_usuario);
        $data['total_pagar'] = $this->model->calcularTotal($this->id_usuario);
        $data['vendedores'] = $this->model->getVendedores();

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function delete($id)
    {
        $data = $this->model->deleteDetalle($id, 'detalle_cotizacion');
        if ($data == 'ok') {
            $msg = array('msg' => 'Producto Eliminado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el producto', 'icono' => 'error');
        }
        echo json_encode($msg);
        die();
    }

    //Cotizacion
    public function cantidad($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $cant = $array[1];
        if (is_numeric($id) && is_numeric($cant)) {
            if ($cant > 0) {
                $data = $this->model->actualizarCantidad('detalle_cotizacion', $cant, $id);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al agregar la cantidad', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'La cantidad debe ser mayor a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function precio($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $cant = $array[1];
        if (is_numeric($id) && is_numeric($cant)) {
            if ($cant >= 0) {
                $data = $this->model->actualizarPrecio('detalle_cotizacion', $cant, $id);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Ingresado', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al agregar el precio', 'icono' => 'error');
                }
            } else {
                $msg = array('msg' => 'El precio debe ser mayor o igual a 0', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function descuento($datos)
    {
        $array = explode(",", $datos);
        $id = $array[0];
        $desc = $array[1];
        if (is_numeric($id) && is_numeric($desc)) {
            $data = $this->model->actualizarDescuento('detalle_cotizacion', $desc, $id);
            if ($data == 'ok') {
                $msg = array('msg' => 'Descuento Agregado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al agregar el descuento', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Ingrese un número valido', 'icono' => 'warning');
        }
        echo json_encode($msg);
        die();
    }

    public function generar()
    {
        $id_cliente = $_POST['id_cliente'];
        $nombre_cliente = $_POST['nombre_cliente'];        
        $condicion = $_POST['condicion'];
        $validez = $_POST['validez'];
        $nota = $_POST['nota'];
        $vendedor = $_POST['id_vendedor'];
        $tipo = 1;
        $data = $this->model->getDetalle($this->id_usuario);
        $pagar = $this->model->calcularTotal($this->id_usuario);
        $fecha = $_POST['fecha'];
        $hora = date('H:i:s');
        $fecha_fin = date("Y-m-d", strtotime($fecha . '+ ' . $validez . ' days'));
        $cotizacion = $this->model->insertarCotizacion($this->id_usuario, $pagar['total'], $id_cliente, $condicion, $validez, $nota, $fecha, $hora, $fecha_fin, $tipo,$nombre_cliente,$vendedor);
        if ($cotizacion > 0) {
            foreach ($data as $row) {
                $id_pro = $row['id_producto'];
                $cantidad = $row['cantidad'];
                $des = $row['descuento'];
                $precio = $row['precio'];
                $sub_total = $row['sub_total'];
                $this->model->registrar('detalle_cotizaciones', $cotizacion, $id_pro, $cantidad, $des, $precio, $sub_total);
            }
            $eliminar = $this->model->eliminarTemp($this->id_usuario, 'detalle_cotizacion');
            if ($eliminar == 'ok') {
                $msg = array('msg' => 'Cotizacion Generada', 'folio' => $cotizacion, 'icono' => 'success');
            }
        } else {
            $msg = array('msg' => 'Error al generar la cotización', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function generarPdf($folio)
    {
        $data['empresa'] = $this->model->getEmpresa();
        $data['cotizacion'] = $this->model->getCotizacion($folio);
        $data['detalle'] = $this->model->detalleCotizaciones($folio);
        ob_start();
        $html = $this->views->getView('cotizaciones', "reporte", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }

    public function agregarProducto($id_pro)
    {
        $datos = $this->model->getProducto($id_pro);
        $precio = $datos['precio_venta'];
        $cantidad = 1;
        $sub_total = $precio * $cantidad;
        $data = $this->model->registrarDetalle($id_pro, $this->id_usuario, $precio, $cantidad, $sub_total);
        if ($data == "ok") {
            $msg = array('msg' => 'Producto ingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al ingresar el producto', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function historial()
    {
        $data['scripts'] = array(
            array('script' => 'fechas.js'),
            array('script' => 'pages/historial_cotizacion.js')
        );
        $this->views->getView('cotizaciones', "historial", $data);
    }

    public function listarCotizacion()
    {
        $data = $this->model->getHistorial('cotizaciones', $this->id_usuario);
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]['estado'] == 1) {
                $data[$i]['estado'] = '<span class="badge badge-warning">Pendiente</span>';
                /*$data[$i]['acciones'] = '<div>
                    <a href="' . base_url . "cotizaciones/generarPdf/" . $data[$i]['id'] . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <button class="btn btn-outline-info" type="button" onclick="verCotizacion(' . $data[$i]['id'] . ');"><i class="fas fa-eye"></i></button>
                    <div/>';*/
                $data[$i]['estado_txt'] = 'pendiente';
            } else if ($data[$i]['estado'] == 0) {
                $data[$i]['estado'] = '<span class="badge badge-success">Completado</span>';
                $data[$i]['estado_txt'] = 'completado';
                /*$data[$i]['acciones'] = '<div>
                    <a href="' . base_url . "cotizaciones/generarPdf/" . $data[$i]['id'] . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <div/>';*/
            } else {
                $data[$i]['estado'] = '<span class="badge badge-danger">Rechazado</span>';
                $data[$i]['estado_txt'] = 'rechazado';
                $data[$i]['acciones'] = '<div>
                    <a href="' . base_url . "compras/generarCotizacionPdf/" . $data[$i]['id'] . '" target="_blank" class="btn btn-outline-danger"><i class="fas fa-file-pdf"></i></a>
                    <div/>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function generarVenta($accion)
    {
        $array = explode(",", $accion);
        $id = $array[0];
        $estado = $array[1];
        $data = $this->model->actualizarEstado('cotizaciones', $estado, $id);
        if ($data == 'ok') {
            $data = $this->model->getDetalleCotizacion($id);
            $pagar = $this->model->calcularCotizacion($id);
            $datos = $this->model->getCotizacion($id);
            $fecha = date('Y-m-d');
            $hora = date('H:m:s');
            $consult = $this->model->serie('ventas', $datos['tipo']);
            $serie = $consult['serie'] + 1;
            $venta = $this->model->insertarVenta($this->id_usuario, $pagar['total'], $datos['id_cliente'], $fecha, $hora, $datos['condicion_pago'], $datos['tipo'], $serie);
            if ($venta > 0) {
                if ($datos['condicion_pago'] == 2) {
                    $this->model->insertarCredito($venta, $pagar['total'], $datos['id_cliente'], $pagar['total'], $fecha, $this->id_usuario);
                }
                foreach ($data as $row) {
                    $id_pro = $row['id_producto'];
                    $cantidad = $row['cantidad'];
                    $desc = $row['descuento'];
                    $precio = $row['precio'];
                    $sub_total = $row['sub_total'];
                    $this->model->registrar('detalle_ventas', $venta, $id_pro, $cantidad, $desc, $precio, $sub_total);
                    $stock = $this->model->getProducto($id_pro);
                    $total_cantidad = $stock['cantidad'] - $row['cantidad'];
                    $this->model->actualizarStock($total_cantidad, $id_pro);
                }
                $mensaje = array('msg' => 'Venta Generada', 'folio' => $venta, 'icono' => 'success');
            } else {
                $mensaje = array('msg' => 'Error al generar la venta', 'icono' => 'error');
            }
        } else if ($data == 'rechazado') {
            $mensaje = array('msg' => 'Venta Rechazada', 'icono' => 'warning');
        } else {
            $mensaje = array('msg' => 'Error al actualizar el estado', 'icono' => 'error');
        }
        echo json_encode($mensaje, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function verDetalle(int $folio)
    {
        $data['fecha'] = date('Y-m-d');
        $data['cotizacion'] = $this->model->getCotizacion($folio);
        $data['productos'] = $this->model->detalleCotizaciones($folio);
        $data['total'] = 0.00;
        foreach ($data['productos'] as $row) {
            $data['total'] = $data['total'] + $row['sub_total'];
        }
        $data['total_cotizacion'] = number_format($data['total'], 2, '.', ',');

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
}
