<?php
class Medidas extends Controller
{
    private $id_usuario;

    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'pages/medidas.js')
        );
        $this->views->getView('productos', "medidas", $data);
    }

    public function listar()
    {
        $data = $this->model->getMedidas();
        for ($i = 0; $i < count($data); $i++) {
            if ($data[$i]['estado'] == 1) {
                $data[$i]['editar'] = '<button class="btn btn-primary" type="button" onclick="btnEditarMed(' . $data[$i]['id'] . ');"><i class="fas fa-edit"></i></button>';
                $data[$i]['eliminar'] = '<button class="btn btn-danger" type="button" onclick="btnEliminarMed(' . $data[$i]['id'] . ');"><i class="fas fa-trash-alt"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-success">Activo</span>';
                $data[$i]['estado_txt'] = 'activo';
            } else {
                $data[$i]['editar'] = '';
                $data[$i]['eliminar'] = '<button class="btn btn-success" type="button" onclick="btnReingresarMed(' . $data[$i]['id'] . ');"><i class="fas fa-circle"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-danger">Inactivo</span>';
                $data[$i]['estado_txt'] = 'inactivo';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function registrar()
    {
        $medida = strClean($_POST['medida']);
        $nombre_corto = strClean($_POST['nombre_corto']);
        $id = strClean($_POST['id']);
        if (empty($medida) || empty($nombre_corto)) {
            $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'error');
        } else {
            if ($id == "") {
                $data = $this->model->registrarMed($medida, $nombre_corto);
                if ($data == "ok") {
                    $msg = array('msg' => 'Medida registrado', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'El Medida ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar la Medida', 'icono' => 'error');
                }
            } else {
                $data = $this->model->modificarMed($medida, $nombre_corto, $id);
                if ($data == "modificado") {
                    $msg = array('msg' => 'Medida modificado con éxito', 'icono' => 'success');
                } else {
                    $msg = "Error al modificar el Medida";
                    $msg = array('msg' => 'Error al modificar la Medida', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editar($id)
    {
        $data = $this->model->editarMed($id);
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function eliminar($id)
    {
        $data = $this->model->accionMed(0, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Medida dado de baja', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar la Medida', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function reingresar($id)
    {
        $data = $this->model->accionMed(1, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Medida reingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al reingresar la Medida', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
}
