<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;

class Productos extends Controller
{
    private $id_usuario;

    public function __construct()
    {
        session_start();
        parent::__construct();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        $data['scripts'] = array(
            array('script' => 'pages/productos.js')
        );
        $data['proveedor'] = $this->model->getDatos('proveedor');
        $data['medidas'] = $this->model->getDatos('medidas');
        $data['categorias'] = $this->model->getDatos('categorias');
        $data['marcas'] = $this->model->getDatos('marcas');
        $this->views->getView('productos', "index", $data);
    }

    public function listar()
    {
        define('FOTO', 0);

        define('ESTADO', 11);
        define('ULTIMAVENTA', 12);
        define('DIASDIFERENCIA', 13);

        $data = $this->model->getProductos_ss();

        for ($i = 0; $i < count($data['aaData']); $i++) {
            //if(trim($data['aaData'][$i][FOTO])=='') {$data['aaData'][$i][0]='default.webp';}
            $data['aaData'][$i][FOTO] = '<img class="img-thumbnail" src="' . base_url . 'Assets/img/pro/min/' . $data['aaData'][$i][FOTO].'" width="50" onerror="this.onerror=null;this.src=\'' . base_url . 'Assets/img/pro/min/default.webp\';">';

            if ($data['aaData'][$i][ESTADO] == 1) {
                $data['aaData'][$i][ESTADO] = '<span class="badge badge-success">Activo</span>';
            } else {
                $data['aaData'][$i][ESTADO] = '<span class="badge badge-danger">Inactivo</span>';
            }

            $fecha=explode('-',$data['aaData'][$i][12]);

            if($data['aaData'][$i][DIASDIFERENCIA]<=30) {
                $data['aaData'][$i][ULTIMAVENTA]="<span class='badge badge-success'>{$fecha[2]}/{$fecha[1]}/{$fecha[0]}</span>";
            } else if($data['aaData'][$i][DIASDIFERENCIA]<=60) {
                $data['aaData'][$i][ULTIMAVENTA]="<span class='badge badge-warning'>{$fecha[2]}/{$fecha[1]}/{$fecha[0]}</span>";
            } else if($data['aaData'][$i][DIASDIFERENCIA]>60) {
                $data['aaData'][$i][ULTIMAVENTA]="<span class='badge badge-danger'>{$fecha[2]}/{$fecha[1]}/{$fecha[0]}</span>";
            }
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
        

        /*$data = $this->model->getProductos();
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['editar'] = '';
            $data[$i]['accion'] = '';
            $data[$i]['foto'] = '<img class="img-thumbnail" src="' . base_url . 'Assets/img/pro/' . $data[$i]['foto'] . '" width="50">';
            if ($data[$i]['estado'] == 1) {
                $data[$i]['editar'] = '<button class="btn btn-primary" type="button" onclick="btnEditarPro(' . $data[$i]['id'] . ');"><i class="fas fa-edit"></i></button>';
                $data[$i]['eliminar'] = '<button class="btn btn-danger" type="button" onclick="btnEliminarPro(' . $data[$i]['id'] . ');"><i class="fas fa-trash-alt"></i></button>';
                $data[$i]['accion'] = '<button class="btn btn-outline-dark" type="button" onclick="btnVerPro(' . $data[$i]['id'] . ');"><i class="fas fa-barcode"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-success">Activo</span>';
                $data[$i]['estado_txt'] = 'activo';
            } else {
                $data[$i]['eliminar'] = '<button class="btn btn-success" type="button" onclick="btnReingresarPro(' . $data[$i]['id'] . ');"><i class="fas fa-circle"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-danger">Inactivo</span>';
                $data[$i]['estado_txt'] = 'inactivo';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();*/
    }

    public function registrar()
    {
        $codigo = strClean($_POST['codigo']);

        $ubicacion = strClean($_POST['ubicacion']);
        $observaciones = $_POST['observaciones'];
        $minimo = (float) strClean($_POST['minimo']);
        $maximo = (float) strClean($_POST['maximo']);

        $precio_compra = (float) strClean($_POST['precio_compra']);
        $precio_venta = (float) strClean($_POST['precio_venta']);
        $precio1 = (float) strClean($_POST['precio1']);
        $precio2 = (float) strClean($_POST['precio2']);
        $precio3 = (float) strClean($_POST['precio3']);
        $precio4 = (float) strClean($_POST['precio4']);
        $precio5 = (float) strClean($_POST['precio5']);

        $estado=(isset($_POST['estado']))?'1':'0';
        $imprime=(isset($_POST['imprime']))?'1':'0';

        $codigo_alter = strClean($_POST['codigo_alter']);
        $codigo_proveedor = strClean($_POST['codigo_proveedor']);
        $descripcion = strClean($_POST['descripcion']);
        $detalles = strClean($_POST['detalles']);
        $clasificacion = strClean($_POST['clasificacion']);

        $tipo = strClean($_POST['tipo']);
        $proveedor = strClean($_POST['proveedor']);

        $medidas = strClean($_POST['medidas']);
        $categorias = strClean($_POST['categorias']);
        $marcas = strClean($_POST['marcas']);

        $id = strClean($_POST['id']);
        $img = $_FILES['imagen'];
        $name = $img['name'];
        $tmpname = $img['tmp_name'];

        $fecha = date("YmdHis");
        if (empty($codigo)) {
            $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'warning');
        } else {
            if (!empty($name)) {
                $imgNombre = $fecha . ".jpg";
                $destino = "Assets/img/pro/" . $imgNombre;
            } else if (!empty($_POST['foto_actual']) && empty($name)) {
                $imgNombre = $_POST['foto_actual'];
            } else {
                $imgNombre = "default.png";
            }

            if ($id == "") {
                $data = $this->model->registrarProducto(
                    $codigo,
                    $imgNombre,
                    $ubicacion,
                    $observaciones,
                    $minimo,
                    $maximo,
                    $precio_compra,
                    $precio_venta,
                    $precio1,
                    $precio2,
                    $precio3,
                    $precio4,
                    $precio5,
                    $estado,
                    $imprime,
                    $codigo_alter,
                    $codigo_proveedor,
                    $descripcion,
                    $detalles,
                    $clasificacion,
                    $tipo,
                    $proveedor,
                    $medidas,
                    $categorias,
                    $marcas
                );
                if ($data == "ok") {
                    if (!empty($name)) {
                        move_uploaded_file($tmpname, $destino);
                    }
                    $msg = array('msg' => 'Producto registrado con éxito', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'El producto ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al registrar el producto', 'icono' => 'error');
                }
            } else {
                $imgDelete = $this->model->editarPro($id);
                if ($imgDelete['foto'] != 'default.png') {
                    if (file_exists("Assets/img/pro/" . $imgDelete['foto'])) {
                        unlink("Assets/img/pro/" . $imgDelete['foto']);
                    }
                }
                $data = $this->model->modificarProducto(
                                $codigo,
                                $imgNombre,
                                $id,
                                $ubicacion,
                                $observaciones,
                                $minimo,
                                $maximo,
                                $precio_compra,
                                $precio_venta,
                                $precio1,
                                $precio2,
                                $precio3,
                                $precio4,
                                $precio5,
                                $estado,
                                $imprime,
                                $codigo_alter,
                                $codigo_proveedor,
                                $descripcion,
                                $detalles,
                                $clasificacion,
                                $tipo,
                                $proveedor,
                                $medidas,
                                $categorias,
                                $marcas                                                                                
                            );
                if ($data == "modificado") {
                    if (!empty($name)) {
                        move_uploaded_file($tmpname, $destino);
                    }
                    $msg = array('msg' => 'Producto modificado con éxito', 'icono' => 'success');
                } else if ($data == "existe") {
                    $msg = array('msg' => 'El producto ya existe', 'icono' => 'warning');
                } else {
                    $msg = array('msg' => 'Error al modificar el producto', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function editar(int $id)
    {
        $data = $this->model->editarPro($id);
        if($data['fecha_ultimacompra']!==NULL) {
                $data['fecha_ultimacompra']=date('d/m/Y', strtotime($data['fecha_ultimacompra']));
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function eliminar(int $id)
    {
        $data = $this->model->accionPro(0, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Producto dado de baja', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el producto', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function reingresar(int $id)
    {
        $data = $this->model->accionPro(1, $id);
        if ($data == 1) {
            $msg = array('msg' => 'Producto reingresado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al reingresar el producto', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function barcode()
    {
        require 'vendor/autoload.php';
        $generator = new Picqer\Barcode\BarcodeGeneratorHTML();
        $data['productos'] = $this->model->getProductos();
        foreach ($data['productos'] as $row) {
            $redColor = [0, 0, 0];
            $generator = new Picqer\Barcode\BarcodeGeneratorPNG();
            file_put_contents('Assets/img/barcode/' . $row['id'] . '.png', $generator->getBarcode($row['codigo'], $generator::TYPE_CODE_128, 3, 50, $redColor));
        }
        ob_start();
        $html = $this->views->getView('productos', "reporte-barcode", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }

    public function generarEtiqueta()
    {
        $data['codigo'] = strClean($_POST['codigo_barra']);
        $data['cantidad'] = strClean($_POST['cantidad_etiqueta']);
        if (empty($data['codigo']) || empty($data['cantidad'])) {
            header('Location: ' . base_url . 'errors');
        } else if (!is_numeric($data['cantidad'])) {
            header('Location: ' . base_url . 'errors');
        } else {
            try {
                require 'vendor/autoload.php';
                $generator = new Picqer\Barcode\BarcodeGeneratorHTML();
                $generator = new Picqer\Barcode\BarcodeGeneratorPNG();
                file_put_contents('Assets/img/barcode.png', $generator->getBarcode($data['codigo'], $generator::TYPE_CODE_128, 2, 30));
                ob_start();
                $html = $this->views->getView('productos', "reporte-etiqueta", $data);
                $html = ob_get_clean();
                require_once 'vendor/autoload.php';
                $mpdf = new \Mpdf\Mpdf();
                // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
                $mpdf->WriteHTML($html);
                $mpdf->Output();
            } catch (PDOException $th) {
                header('Location: ' . base_url . 'errors');
            }
        }
    }

    public function excel($vars)
    {
        $params = explode('|',urldecode(base64_decode($vars)));

        $fecha_min = $params[0];
        $fecha_max = $params[1];
        $categoria = $params[2];
        $marca = $params[3];
        $search = $params[4];

        require 'vendor/autoload.php';
        $spreassheet = new Spreadsheet();
        $spreassheet->getProperties()->setCreator($_SESSION['usuario'])->setTitle('Reporte de Productos');
        $spreassheet->setActiveSheetIndex(0);
        $hojaActiva = $spreassheet->getActiveSheet();
        $hojaActiva->getColumnDimension('A')->setWidth(15);
        $hojaActiva->getColumnDimension('B')->setWidth(50);
        $hojaActiva->getColumnDimension('C')->setWidth(15);
        $hojaActiva->getColumnDimension('D')->setWidth(15);
        $hojaActiva->getColumnDimension('E')->setWidth(10);

        $data['empresa'] = $this->model->getEmpresa();

        $hojaActiva->setCellValue('A1', 'DISTRIBUIDORA MULTIVERSAL AD');        
        $hojaActiva->setCellValue('A2', 'Reporte de Inventario');

        $spreassheet->getActiveSheet()->getStyle('A4:E4')->getFill()
            ->setFillType(Fill::FILL_SOLID)
            ->getStartColor()->setARGB('0099ff');

        $spreassheet->getActiveSheet()->getStyle('A4:E4')
            ->getFont()->getColor()->setARGB(Color::COLOR_WHITE);

        $hojaActiva->setCellValue('A4', 'Código');
        $hojaActiva->setCellValue('B4', 'Descripción');
        $hojaActiva->setCellValue('C4', 'Precio Compra');
        $hojaActiva->setCellValue('D4', 'Precio Venta');
        $hojaActiva->setCellValue('E4', 'Existencia');
        $data = $this->model->getProductosExcel($fecha_min, $fecha_max, $categoria, $marca, $search);

        $fila = 5;
        foreach ($data as $row) {
            $hojaActiva->setCellValue('A' . $fila, $row['codigo']);
            $hojaActiva->setCellValue('B' . $fila, $row['descripcion']);
            if ($row['cantidad'] == 0) {
                $spreassheet->getActiveSheet()->getStyle('E' . $fila)
                    ->getFont()->getColor()->setARGB(Color::COLOR_RED);
            }
            $hojaActiva->setCellValue('C' . $fila, $row['precio_compra']);
            $hojaActiva->setCellValue('D' . $fila, $row['precio_venta']);
            $hojaActiva->setCellValue('E' . $fila, $row['cantidad']);
            $fila++;
        }
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="productos.xlsx"');
        header('Cache-Control: max-age=0');

        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreassheet, 'Xlsx');
        $writer->save('php://output');
    }

    public function pdf($vars)
    {
        $data['empresa'] = $this->model->getEmpresa();

        $params = explode('|',urldecode(base64_decode($vars)));

        $fecha_min = $params[0];
        $fecha_max = $params[1];
        $categoria = $params[2];
        $marca = $params[3];
        $search = $params[4];

        $data['productos'] = $this->model->getProductosReporte($fecha_min, $fecha_max, $categoria, $marca, $search);

        ob_start();
        $html = $this->views->getView('productos', "reporte-pdf", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf();
        $mpdf->SetWatermarkImage('Assets/img/logo.png');
        $mpdf->showWatermarkImage = true;
        // $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->WriteHTML($html);
        $mpdf->Output();
    }

    public function pdfFicha($idproducto)
    {
        $data['empresa'] = $this->model->getEmpresa();
        $data['producto'] = $this->model->editarProducto($idproducto);
        
        ob_start();
        $html = $this->views->getView('productos', "ficha-producto", $data);
        $html = ob_get_clean();

        require 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([
            'format' => 'Letter',
            'margin_left' => 10,
            'margin_right' => 10,
            'margin_top' => 10,
            'margin_bottom' => 20,
            'margin_header' => 3,
            'margin_footer' => 3,
            'default_font' => 'arial'
        ]);

        $mpdf->SetHTMLHeader('');
        $mpdf->SetHTMLFooter("
        <table style='width:100%;margin-bottom:5mm;'>
            <tr>
                <td style='width:50%;font-size:3mm;padding:2mm;background-color:#{$data['empresa']['color4']}; color:#fff;'>&nbsp;</td>
                <td style='font-size:3mm;line-height:4.5mm;width:45%;padding:2mm;background-color:#{$data['empresa']['color3']}; color:#fff;'>{$data['empresa']['nombre']}<br/>PBX. {$data['empresa']['telefono']}</td>
                <td style='width:5%;font-size:3mm;padding:2mm;background-color:#{$data['empresa']['color1']}; color:#fff;'>&nbsp;</td>
            </tr>
        </table>");

        $mpdf->WriteHTML($html);
        $mpdf->Output('ficha_producto.pdf', 'I');
    }

    public function pdfCat($vars)
    {
        $data['empresa'] = $this->model->getEmpresa();

        $params = explode('|',urldecode(base64_decode($vars)));

        $fecha_min = $params[0];
        $fecha_max = $params[1];
        $categoria = $params[2];
        $marca = $params[3];
        $search = $params[4];

        $data['productos'] = $this->model->getProductosReporteCat($fecha_min, $fecha_max, $categoria, $marca, $search);

        ob_start();
        $html = $this->views->getView('productos', "reporte-catalogo", $data);
        $html = ob_get_clean();

        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([
            'format' => 'Letter',
            'margin_left' => 10,
            'margin_right' => 10,
            'margin_top' => 20,
            'margin_bottom' => 20,
            'margin_header' => 3,
            'margin_footer' => 3,
            'default_font' => 'arial'
        ]);        

        $mpdf->SetHTMLHeader('
            <div class="header">
                <div class="header-left"><p>CATALOGO DE PRODUCTOS</p></div>
                <div class="lateral">
                    <table style="color:#'.$data['empresa']['color3'].';text-align:center;margin-left:11mm;">
                        <tr text-rotate="90">
                            <td style="font-size:12mm; font-weight:bold;">CATÁLOGO&nbsp;</td>
                        </tr>
                    </table>
                </div>
                <div class="header-right">&nbsp;</div>

            </div>');

        $mpdf->SetHTMLFooter('
            <div class="footer">
                <table>
                    <tr>
                        <td class="direccion">
                        <p style="font-size: 1.3mm;">&nbsp;</p>
                        <p style="font-size: 3mm;">'.$data['empresa']['direccion'].'&nbsp;</p>
                        <p style="font-size: 1.3mm;">&nbsp;</p>
                        <h1 style="font-size: 5mm;">PBX: '.$data['empresa']['telefono'].'</h1>
                        </td>
                        <td class="pagina">Pág. {PAGENO}</td>
                    </tr>
                </table>
            </div>
        ');

        $mpdf->WriteHTML($html);
        $mpdf->Output('catalogo_productos.pdf', 'I');
    }

    public function kardex($id)
    {
        $data['empresa'] = $this->model->getEmpresa();
        $data['kardex'] = $this->model->getProductosKardex($id);
        $data['producto'] = $this->model->editarPro($id);
        
        ob_start();
        $html = $this->views->getView('productos', "reportekardex", $data);
        $html = ob_get_clean();
        require_once 'vendor/autoload.php';

        $mpdf = new \Mpdf\Mpdf([]);
        $mpdf->WriteHTML($html);
        $mpdf->Output('Kardex.pdf', 'I');

    }    
}
