<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Usuarios extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        parent::__construct();
    }
    public function index()
    {
        $this->id_usuario = $_SESSION['id_usuario'];
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        $data['cajas'] = $this->model->getCajas();
        $data['scripts'] = array(
            array('script' => 'pages/usuarios.js')
        );
        $this->views->getView('usuarios', "index", $data);
    }
    public function listar()
    {
        $this->id_usuario = $_SESSION['id_usuario'];
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        $data = $this->model->getUsuarios();
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['editar'] = '';
            $data[$i]['rol'] = '';
            $data[$i]['eliminar'] = '';
            if ($data[$i]['estado'] == 1) {
                if ($data[$i]['id'] != 1) {
                    $data[$i]['editar'] = '<button class="btn btn-primary" type="button" onclick="btnEditarUser(' . $data[$i]['id'] . ');"><i class="fas fa-edit"></i></button>';
                    $data[$i]['eliminar'] = '<button class="btn btn-danger" type="button" onclick="btnEliminarUser(' . $data[$i]['id'] . ');"><i class="fas fa-trash-alt"></i></button>';
                    $data[$i]['rol'] = '<a class="btn btn-dark" href="' . base_url . 'usuarios/permisos/' . $data[$i]['id'] . '"><i class="fas fa-key"></i></a>';
                }
                $data[$i]['estado'] = '<span class="badge badge-success">Activo</span>';
            } else {
                $data[$i]['eliminar'] = '<button class="btn btn-success" type="button" onclick="btnReingresarUser(' . $data[$i]['id'] . ');"><i class="fas fa-circle"></i></button>';
                $data[$i]['estado'] = '<span class="badge badge-danger">Inactivo</span>';
            }
        }
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }
    
    public function registrar()
    {
        $usuario = strClean($_POST['usuario']);
        $nombre = strClean($_POST['nombre']);
        $correo = strClean($_POST['correo']);
        $clave = strClean($_POST['clave']);
        $confirmar = strClean($_POST['confirmar']);
        $caja = strClean($_POST['caja']);
        $id = strClean($_POST['id']);
        $hash = password_hash($clave, PASSWORD_DEFAULT);
        $valid_email = filter_var($correo, FILTER_VALIDATE_EMAIL);
        if ($valid_email) {
            if (empty($usuario) || empty($nombre) || empty($correo) || empty($caja)) {
                $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'error');
            } else {
                if ($id == "") {
                    if (empty($clave) || empty($confirmar)) {
                        $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'error');
                    } else {
                        if ($clave != $confirmar) {
                            $msg = array('msg' => 'Las contraseña no coinciden', 'icono' => 'warning');
                        } else {
                            $data = $this->model->registrarUsuario($usuario, $nombre, $correo, $hash, $caja);
                            if ($data == "ok") {
                                $msg = array('msg' => 'Usuario registrado con éxito', 'icono' => 'success');
                            } else if ($data == "existe") {
                                $msg = array('msg' => 'El usuario ya existe', 'icono' => 'warning');
                            } else {
                                $msg = array('msg' => 'Error al registrar el usuario', 'icono' => 'error');
                            }
                        }
                    }
                } else {
                    $data = $this->model->modificarUsuario($usuario, $nombre, $correo, $caja, $id);
                    if ($data == "modificado") {
                        $msg = array('msg' => 'Usuario modificado con éxito', 'icono' => 'success');
                    } else if ($data == "existe") {
                        $msg = array('msg' => 'El usuario ya existe', 'icono' => 'warning');
                    } else {
                        $msg = array('msg' => 'Error al modificar el usuario', 'icono' => 'error');
                    }
                }
            }
        } else {
            $msg = array('msg' => 'Ingresa un correo valido', 'icono' => 'warning');
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function editar(int $id)
    {
        if (is_numeric($id)) {
            $data = $this->model->editarUser($id);
            echo json_encode($data, JSON_UNESCAPED_UNICODE);
            die();
        } else {
            header('Location: ' . base_url . 'errors');
        }
    }
    public function eliminar(int $id)
    {
        if (is_numeric($id)) {
            $data = $this->model->accionUser(0, $id);
            if ($data == 1) {
                $msg = array('msg' => 'Usuario dado de baja', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al eliminar el usuario', 'icono' => 'error');
            }
        } else {
            $msg = array('msg' => 'Error no detectado', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function reingresar(int $id)
    {
        if (is_numeric($id)) {
            $data = $this->model->accionUser(1, $id);
            if ($data == 1) {
                $msg = array('msg' => 'Usuario reingresado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al reingresar el usuario', 'icono' => 'success');
            }
        } else {
            $msg = array('msg' => 'Error no detectado', 'icono' => 'error');
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function perfil()
    {
        $id = $_SESSION['id_usuario'];
        $data = $this->model->getPerfil($id);
        $data['scripts'] = array(
            array('script' => 'pages/perfil.js')
        );
        $this->views->getView('usuarios', 'perfil', $data);
    }
    public function cambiar_datos()
    {
        $usuario = strClean($_POST['usuario']);
        $nombre = strClean($_POST['nombre']);
        $correo = strClean($_POST['correo']);
        if (empty($usuario) || empty($nombre) || empty($correo)) {
            $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'warning');
        } else {
            $data = $this->model->modificarUsuario($usuario, $nombre, $correo, $_SESSION['id_caja'], $_SESSION['id_usuario']);
            if ($data == 'modificado') {
                $msg = array('msg' => 'Datos modificado con exito', 'icono' => 'success');
            }else{
                $msg = array('msg' => 'Error al modificar', 'icono' => 'error');
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function cambiar_pass()
    {
        $actual = strClean($_POST['actual']);
        $nueva = strClean($_POST['nueva']);
        $confirmar = strClean($_POST['confirmar']);
        if (empty($actual) || empty($nueva) || empty($confirmar)) {
            $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'warning');
        } else {
            if ($nueva != $confirmar) {
                $msg = array('msg' => 'Las contraseñas no coinciden', 'icono' => 'warning');
            } else {
                $id = $_SESSION['id_usuario'];
                $data = $this->model->getPerfil($id);
                if (password_verify($actual, $data['clave'])) {
                    $data = $this->model->actualizarPass(password_hash($nueva, PASSWORD_DEFAULT), $id);
                    if ($data == 'ok') {
                        $msg = array('msg' => 'Contraseña modificada con exito', 'icono' => 'success');
                    }
                } else {
                    $msg = array('msg' => 'Contraseña actual incorrecta', 'icono' => 'warning');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
    public function permisos($id)
    {
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        $data['datos'] = $this->model->getPermisos();
        $permisos = $this->model->getDetallePermisos($id);
        $data['asignados'] = array();
        foreach ($permisos as $permiso) {
            $data['asignados'][$permiso['id_permiso']] = true;
        }
        $data['id_usuario'] = $id;
        $data['scripts'] = array(
            array('script' => 'pages/permisos.js')
        );
        $this->views->getView("usuarios", "permisos", $data);
    }
    public function registrarPermisos()
    {
        $id_user = $_POST['id_usuario'];
        $this->model->deletePermisos($id_user);
        if (!empty($_POST['permisos'])) {
            $permisos = $_POST['permisos'];
            foreach ($permisos as $permiso) {
                $this->model->actualizarPermisos($id_user, $permiso);
            }
        }
        $msg = array('msg' => 'Permisos Asignado', 'icono' => 'success');
        echo json_encode($msg);
        die();
    }
    public function recuperar()
    {
        $this->views->getView('usuarios', "recuperar");
    }
    public function salir()
    {
        session_destroy();
        header("location: " . base_url);
    }
    public function enviarCorreo()
    {
        $correo = strClean($_POST['correo']);
        $data = $this->model->getCorreo($correo);
        if (empty($data)) {
            $mensaje = array('msg' => 'El correo no existe, ingrese el correo con la cuál se registro', 'icono' => 'warning');
        } else {
            require 'vendor/autoload.php';
            $mail = new PHPMailer(true);
            try {
                $token = md5(uniqid());
                $datos = $this->model->actualizarToken($token, $correo);
                $empresa = $this->model->getEmpresa();
                if ($datos == 'ok') {
                    $mail->SMTPDebug = 0;
                    $mail->isSMTP();                                            //Send using SMTP
                    $mail->Host       = $empresa['smtp'];                     //Set the SMTP server to send through
                    $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                    $mail->Username   = $empresa['usuario_smtp'];                     //SMTP username
                    $mail->Password   = $empresa['clave_smtp'];                               //SMTP password
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
                    $mail->Port       = $empresa['puerto_smtp'];                                 //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

                    //Recipients
                    $mail->setFrom($empresa['correo'], $empresa['nombre']);
                    $mail->addAddress($correo);     //Add a recipient
                    //Content
                    $mail->isHTML(true);                                  //Set email format to HTML
                    $mail->Subject = 'Usuario';
                    $mail->Body    = '<h1>Restablecer contraseña</h1>
                    <p>Has pedido restablecer tu contraseña, si no has sido tu puedes omitir este correo
                    <b>Atentamente ' . $empresa['nombre'] . '</b>
                    <h6>Para restablecer has click en el siguiente enlace</h6>
                    ' . base_url . 'usuarios/restablecer/' . $token . '
                    </p>
                    ';
                    $mail->CharSet = 'UTF-8';
                    $mail->send();
                    $mensaje = array('msg' => 'Se ha enviado un correo electrónico con el código para restablecer', 'icono' => 'success');
                }
            } catch (Exception $e) {
                $mensaje = array('msg' => $e->getMessage(), 'icono' => 'error');
            }
        }
        echo json_encode($mensaje);
        die();
    }
    public function restablecer($token)
    {
        $data = $this->model->getToken($token);
        if (empty($data)) {
            header('location: ' . base_url);
        } else {
            $this->views->getView('usuarios', 'restablecer', $data);
        }
    }
    public function resetear()
    {
        $id = strClean($_POST['id']);
        $token = strClean($_POST['token']);
        $clave = strClean($_POST['clave_nueva']);
        $confirmar = strClean($_POST['confirmar']);
        if (empty($clave) || empty($confirmar)) {
            $msg = array('msg' => 'Todo los campos son obligatorios', 'icono' => 'warning');
        } else {
            if ($clave != $confirmar) {
                $msg = array('msg' => 'Las contraseñas no coinciden', 'icono' => 'warning');
            } else {
                $data = $this->model->resetearPass(password_hash($clave, PASSWORD_DEFAULT), $id, $token);
                if ($data == 'ok') {
                    $msg = array('msg' => 'Contraseña restablecida con exito', 'icono' => 'success');
                } else {
                    $msg = array('msg' => 'Error al restablecer la contraseña', 'icono' => 'error');
                }
            }
        }
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
}
