<?php
class CotizacionesModel extends Query
{
    public function __construct()
    {
        parent::__construct();
    }
    public function buscarProducto(string $cod)
    {
        $sql = "SELECT * FROM productos WHERE codigo LIKE '%" . $cod . "%' AND estado = 1 OR descripcion LIKE '%" . $cod . "%' AND estado = 1 LIMIT 10";
        $data = $this->selectAll($sql);
        return $data;
    }
    
    public function getProducto(int $id)
    {
        $sql = "SELECT * FROM productos WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function getCliente(int $id)
    {
        $sql = "SELECT * FROM clientes WHERE id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function getDetalle(int $id)
    {
        $sql = "SELECT d.*, p.descripcion,p.foto FROM detalle_cotizacion d INNER JOIN productos p ON d.id_producto = p.id WHERE d.id_usuario = $id";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getDetalleCotizacion(int $folio)
    {
        $sql = "SELECT d.*, p.descripcion FROM detalle_cotizaciones d INNER JOIN productos p ON d.id_producto = p.id WHERE d.folio = $folio";
        $data = $this->selectAll($sql);
        return $data;
    }

	public function getVendedores()
    {
        $sql = "SELECT codven, nombre FROM vendedores ";
        $data = $this->selectAll($sql);
        return $data;
    }

    public function getCotizacion(int $id)
    {
        //$sql = "SELECT c.*, cl.nombre, cl.telefono, cl.direccion FROM cotizaciones c INNER JOIN clientes cl ON c.id_cliente = cl.id WHERE c.id = $id";
        $sql = "SELECT c.*, nombre_cliente as nombre FROM cotizaciones c WHERE c.id = $id";
        $data = $this->select($sql);
        if($data['id_cliente']>0) {
            $cliente=$this->getCliente($data['id_cliente']);
            $data['telefono']=$cliente['telefono'];
            $data['direccion']=$cliente['direccion'];
        } else {
            $data['telefono']='--';
            $data['direccion']='--';
        }

        return $data;
    }
    public function calcularTotal(int $id_usuario)
    {
        $sql = "SELECT SUM(sub_total) AS total FROM detalle_cotizacion WHERE id_usuario = $id_usuario";
        $data = $this->select($sql);
        return $data;
    }
    public function calcularDescuento(int $folio)
    {
        $sql = "SELECT descuento, SUM(descuento) AS total FROM detalle_ventas WHERE folio = $folio";
        $data = $this->select($sql);
        return $data;
    }
    public function calcularCotizacion(int $folio)
    {
        $sql = "SELECT SUM(sub_total) AS total FROM detalle_cotizaciones WHERE folio = $folio";
        $data = $this->select($sql);
        return $data;
    }
    public function deleteDetalle(int $id, string $table)
    {
        $sql = "DELETE FROM $table WHERE id = ?";
        $datos = array($id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function insertarCotizacion(int $id, string $total, int $id_cli,int $condicion_pago, int $validez, string $nota, string $fecha, string $hora, string $fecha_fin, int $tipo, string $nombre_cliente, int $vendedor)
    {
        $sql = "INSERT INTO cotizaciones (id_usuario, total, id_cliente, condicion_pago, validez, nota,fecha,hora,fecha_fin,tipo,nombre_cliente,id_vendedor) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        $datos = array($id, $total, $id_cli, $condicion_pago, $validez, $nota, $fecha, $hora, $fecha_fin, $tipo, $nombre_cliente, $vendedor);

        $newcotizacion=$this->insertar($sql, $datos);

        if((int)$id_cli>0)
        {
            $sql = "UPDATE `cotizaciones` SET `nombre_cliente`=(SELECT `clientes`.`nombre` FROM `clientes` WHERE `clientes`.`id`=`cotizaciones`.`id_cliente` LIMIT 1) WHERE id=?";
            $datos = array($newcotizacion);
            $this->save($sql, $datos);            
        }
        return $newcotizacion;
    }

    public function registrarDetalles(int $id, int $id_pro, string $cantidad, string $descuento, string $precio, string $sub_total)
    {
        $sql = "INSERT INTO detalle_compra (folio, id_producto, cantidad, descuento, precio, sub_total) VALUES (?,?,?,?,?,?)";
        $datos = array($id, $id_pro, $cantidad, $descuento, $precio, $sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function registrar(string $table,int $id, int $id_pro, string $cantidad, string $descuento, string $precio, string $sub_total)
    {
        $sql = "INSERT INTO $table (folio, id_producto, cantidad, descuento, precio ,sub_total) VALUES (?,?,?,?,?,?)";
        $datos = array($id, $id_pro, $cantidad, $descuento, $precio, $sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function eliminarTemp(int $id_usuario, string $table)
    {
        $sql = "DELETE FROM $table WHERE id_usuario = ?";
        $datos = array($id_usuario);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $msg = 'ok';
        }else{
            $msg = 'error';
        }
        return $msg;
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }

    public function getHistorial(string $table, int $id_usuario)
    {
        //$sql = "SELECT c.id, c.nombre, v.* FROM clientes c INNER JOIN $table v ON v.id_cliente = c.id WHERE v.id_usuario = $id_usuario";
        $sql = "SELECT id,nombre_cliente as nombre, total, fecha, estado FROM $table v";
        
        $data = $this->selectAll($sql);
        return $data;
    }
    public function detalleCotizaciones(int $folio)
    {
        $sql = "SELECT c.*, d.*, p.descripcion, p.cantidad AS stock FROM cotizaciones c INNER JOIN detalle_cotizaciones d ON c.id = d.folio INNER JOIN productos p ON p.id = d.id_producto WHERE c.id = $folio";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function actualizarStock(int $cantidad, int $id)
    {
        $sql = "UPDATE productos SET cantidad = ? WHERE id = ?";
        $datos = array($cantidad, $id);
        $this->save($sql, $datos);
    }
    public function registrarDetalle(int $id_producto, int $id_usuario, string $precio, int $cantidad,string $sub_total)
    {
        $sql = "INSERT INTO detalle_cotizacion (id_producto, id_usuario, precio, cantidad,sub_total) VALUES (?,?,?,?,?)";
        $datos = array($id_producto, $id_usuario, $precio, $cantidad,$sub_total);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function actualizarEstado(string $table, int $estado, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            if ($estado == 0) {
                $res = "ok";
            }else{
                $res = "rechazado";
            }
        } else {
            $res = "error";
        }
        return $res;
    }
    public function actualizarCantidad(string $table, string $cant, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($cant * $data['precio']) - $data['descuento'];
        $sql = "UPDATE $table SET cantidad = ?, sub_total = ? WHERE id = ?";
        $datos = array($cant, $sub_total, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function actualizarPrecio(string $table, string $precio, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($precio * $data['cantidad']) - $data['descuento'];
        $sql = "UPDATE $table SET precio = ?, sub_total = ? WHERE id = ?";
        $datos = array($precio, $sub_total, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }

    public function actualizarDescuento(string $table, string $desc, int $id)
    {
        $sql = "SELECT * FROM $table WHERE id = $id";
        $data = $this->select($sql);
        $sub_total = ($data['cantidad'] * $data['precio']) - $desc;
        $sql = "UPDATE $table SET descuento = ?, sub_total = ? WHERE id = ?";
        $datos = array($desc, $sub_total ,$id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function serie(string $table, int $tipo)
    {
        $sql = "SELECT id, tipo, serie FROM $table WHERE tipo = $tipo ORDER BY id DESC LIMIT 1";
        $data = $this->select($sql);
        return $data;
    }
    public function insertarVenta(int $id, string $total, int $id_cli, string $fecha, string $hora, int $forma, int $tipo, int $serie)
    {
        $sql = "INSERT INTO ventas (id_usuario, total, id_cliente, fecha, hora, forma_pago, tipo, serie) VALUES (?,?,?,?,?,?,?,?)";
        $datos = array($id, $total, $id_cli, $fecha, $hora, $forma, $tipo, $serie);
        $data = $this->insertar($sql, $datos);
        if ($data > 0) {
            $res = $data;
        } else {
            $res = 0;
        }
        return $res;
    }
    public function insertarCredito(int $id, string $total, int $id_cli,string $restante, string $fecha, int $id_usuario)
    {
        $sql = "INSERT INTO creditos (venta, monto, cliente, restante, fecha, id_usuario) VALUES (?,?,?,?,?,?)";
        $datos = array($id, $total, $id_cli,$restante, $fecha, $id_usuario);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
}