<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte</title>
    <link rel="stylesheet" href="<?php echo base_url . 'Assets/css/reporte.css'; ?>">
</head>

<body>
    <table id="datos-empresa">
        <tr>
            <td class="logo">
                <img src="<?php echo base_url . 'Assets/img/logo.png'; ?>" alt="" width="150">
            </td>
            <td class="info-empresa">
                <p><b><?php echo $data['empresa']['nombre']; ?></b></p>
            </td>
        </tr>
    </table>

    <h2 style='text-align:center;'>CUENTAS POR COBRAR</h2>

    <? if((int)$data['cliente']['id']!==0) { ?>
        <P>
            <strong>CLIENTE:</strong> <?php echo $data['cliente']['id'] ?><br/>
            <strong>NOMBRE:</strong> <?php echo $data['cliente']['nombre'] ?>
        </P>
    <? } ?>


    <table cellspacing=0>
        <thead>
            <tr>
                <th class="text-right">FACTURA</th>
                <th class="text-left">FECHA</th>
                <th class="text-right">VALOR</th>
                <th class="text-right">ABONOS</th>
                <th class="text-right">SALDO</th>
                <th class="text-right" style='width:40mm'>DIAS DE ATRASO</th>
            </tr>
            <tr class='blanco'>
                <th colspan='6'>&nbsp;</th>
            </tr>            
        </thead>
        <tbody>
            <?php
            $total_valor = 0;
            $total_abonos = 0;
            $total_saldo = 0;

            $total_valor_general = 0;
            $total_abonos_general = 0;
            $total_saldo_general = 0;
            
            $primero=true;
            $idcliente=false;
            $cambio_cliente=false;            

            foreach ($data['detalle'] as $producto) {

                if($idcliente!=$producto['IDCLIENTE'])
                {
                    $idcliente=$producto['IDCLIENTE'];
                    $cambio_cliente=true;
                }                

                if($cambio_cliente===true && (int)$data['cliente']['id']===0)
                {
                    if($primero===false)
                    {
                    ?>
                        <tr>
                            <th class="text-right fborder" colspan=2>TOTAL CLIENTE</th>
                            <th class="text-right fborder"><?php echo number_format($total_valor,2,'.',','); ?></th>
                            <th class="text-right fborder"><?php echo number_format($total_abonos,2,'.',','); ?></th>
                            <th class="text-right fborder"><?php echo number_format($total_saldo,2,'.',','); ?></th>
                            <th class="text-right fborder"></th>
                        </tr>
                    <?
                    }

                    ?>
                        <tr>
                            <th colspan='6' class='text-left'><?php echo "[{$producto['IDCLIENTE']}] {$producto['CLIENTE']}"; ?></th>
                        </tr>
                    <?
                    
                    $total_valor = 0;
                    $total_abonos = 0;
                    $total_saldo = 0;                    
                }

                $total_valor  += $producto['VALOR'];
                $total_abonos += $producto['ABONO'];
                $total_saldo  += $producto['SALDO'];

                $total_valor_general  += $producto['VALOR'];
                $total_abonos_general += $producto['ABONO'];
                $total_saldo_general  += $producto['SALDO'];                 
                ?>
                <tr>
                    <td class="text-right"><?php echo $producto['FACTURA']; ?></td>
                    <td><?php echo date('d/m/Y', strtotime($producto['FECHA'])); ?></td>
                    <td class="text-right"><?php echo number_format($producto['VALOR'],2,'.',','); ?></td>
                    <td class="text-right"><?php echo number_format($producto['ABONO'],2,'.',','); ?></td>
                    <td class="text-right"><?php echo number_format($producto['SALDO'],2,'.',',');; ?></td>
                    <td class="text-right"><?php echo $producto['DIAS_DE_ATRASO']; ?></td>
                </tr>
                <?php
                    $cambio_cliente=false;
                    $primero=false; 
                }
                ?>
                <? if((int)$data['cliente']['id']===0) { ?>
                <tr>
                    <th class="text-right fborder" colspan=2>TOTAL CLIENTE</th>
                    <th class="text-right fborder"><?php echo number_format($total_valor,2,'.',','); ?></th>
                    <th class="text-right fborder"><?php echo number_format($total_abonos,2,'.',','); ?></th>
                    <th class="text-right fborder"><?php echo number_format($total_saldo,2,'.',','); ?></th>
                    <th class="text-right fborder"></th>
                </tr>
                <? } ?>
        </tbody>
        <tfoot>
            <tr>
                <th></th>
                <th></th>
                <th class="text-right fborder"><?php echo number_format($total_valor_general,2,'.',','); ?></th>
                <th class="text-right fborder"><?php echo number_format($total_abonos_general,2,'.',','); ?></th>
                <th class="text-right fborder"><?php echo number_format($total_saldo_general,2,'.',','); ?></th>
            </tr>
            <tr>
                <th colspan='2'></th>
                <th class="text-right fdborder" colspan='3'>&nbsp;</th>
            </tr>            
        </tfoot>
    </table>

</body>

</html>

<style type='text/css'>
THEAD TR TH {
    background: #ccc;
    border-top: 1px solid #000;
    padding-left:5mm;
    padding-right:5mm;
    font-size:3mm;
}


THEAD TR.blanco TH {
    background: #fff;
    border-bottom: 1px solid #000;
    height:2px;
    font-size:2px;
    line-height:2px;
}
.text-left { text-align:left; }
.text-right { text-align:right; }
TBODY TR TD {
    font-size:3mm;
    padding-top:0.5mm;
    padding-bottom:0.5mm;
    padding-left:5mm;
    padding-right:5mm;
}
TBODY TR TH {
    font-size:3mm;
    padding-top:0.5mm;
    padding-bottom:0.5mm;
    padding-left:5mm;
    padding-right:5mm;
    border-top:1px solid #000;
    border-bottom:1px solid #000;
}
TFOOT TR TH {
    padding-left:5mm;
    padding-right:5mm;
    font-size:3mm;
}
TFOOT TR TH.fborder {
    border-top: 1px solid #000;
    background: #ccc;
}
TFOOT TR TH.fdborder {
    border-top: 1px solid #000;
    border-bottom: 1px solid #000;
    height:2px;
    font-size:2px;
    line-height:2px;
}
</style>