let t_h_cot;
const validez = document.getElementById("validez");
const condicion = document.getElementById("condicion");
const nota = document.getElementById("nota");
const id_cliente = document.getElementById("id_cliente");
const btnGenerar = document.getElementById('btnGenerar');
const btnClientesHide = document.getElementById('btnClientesHide');
const btnClientesShow = document.getElementById('btnClientesShow');
const areaCliente = document.getElementById('areaCliente');
const areaClienteMinimizado = document.getElementById('areaClienteMinimizado');


const customCheck = document.getElementById("customCheck");
const buscarClienteContainer = document.getElementById("buscarClienteContainer");
const ClienteContainer = document.getElementById("ClienteContainer");
const buscarCliente = document.getElementById("buscarCliente");
const nombreCliente = document.getElementById("nombreCliente");
const vendedores = document.getElementById("vendedores");
const fecha = document.getElementById("fecha");

let showCliente=true;

let countAutocomplete=0;

document.addEventListener('DOMContentLoaded', function () {
    //Autocomplete - Jquery UI, Buscar Productos para la Cotizacion
    $("#buscarProducto").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'cotizaciones/buscarProducto',
                dataType: "json",
                data: {
                    pro: request.term
                },
                success: function (data) {
                    if (data.length > 0) {
                        response(data);
                    } else {
                        document.getElementById('error_producto').textContent = 'No hay Producto Similar';
                    }
                }
            });
        },
        response: function( event, ui ) { countAutocomplete=-1; },
        classes: { "ui-autocomplete": "autocompleteOverflow" },
        select: function (event, ui) {
            document.getElementById('error_producto').textContent = '';
            const id_pro = ui.item.id;
            ingresarCotizacion(id_pro);
        },
        create: function (event,ui){

            $(this).autocomplete( "instance" )._renderItem = function (ul, item) {

                countAutocomplete++;                

                return $( "<li></li>" )
                .data("item.autocomplete", item)
                .append(`<div class='autocompleteProduct'>
                    <div class="row">
                        <div class='col-12 col-md-2'>
                            <img src="https://ad.sismosoluciones.com/Assets/img/pro/${item[countAutocomplete].foto}">
                        </div>
                        <div class='col-12 col-md-8'>
                            <h3 class='mb-0 '>${item[countAutocomplete].descripcion}</h3>
                            <p class='mb-0'>${item[countAutocomplete].detalles}</p>
                            <h4 class='mb-0'>
                                <span class="badge badge-warning">${item[countAutocomplete].codigo}</span>
                                <span class="badge badge-secondary">${item[countAutocomplete].codigo_alter}</span>
                            </h4>
                            <p class='mb-0'>${item[countAutocomplete].observaciones}</p>
                        </div>
                        <div class='col-12 col-md-2'>
                            <h2 class='text-right mb-0'><strong>Q.${item[countAutocomplete].precio_venta}</strong></h2>
                            <h6 class='text-right'><span class="badge badge-danger">Existencia ${item[countAutocomplete].cantidad}</span></h6>
                        </div>
                    </div>
                </div>`)
                .appendTo( ul );
            };
        }
    })

    //Autocomplete - Jquery UI, Buscar Clientes para la Venta
    $("#buscarCliente").autocomplete({
        minLength: 2,
        source: function (request, response) {
            $.ajax({
                url: base_url + 'clientes/buscarCliente',
                dataType: "json",
                data: {
                    q: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('id_cliente').value = ui.item.id;
            vendedores.value=ui.item.vendedor;
        }
    })

    cargarDetalle()

    btnGenerar.addEventListener('click', imprimirCotizacion);
    btnClientesHide.addEventListener('click', toggleClientes);
    btnClientesShow.addEventListener('click', toggleClientes);
    fecha.value = new Date().toISOString().substring(0, 10);
})

function toggleClientes()
{
    showCliente=!showCliente;

    if(showCliente===true)
    {
        btnClientesHide.classList.remove("d-none")
        btnClientesShow.classList.add("d-none")
        areaCliente.classList.remove("d-none")
        areaClienteMinimizado.classList.add("d-none")
    } else {
        btnClientesHide.classList.add("d-none")
        btnClientesShow.classList.remove("d-none")
        areaCliente.classList.add("d-none")
        areaClienteMinimizado.classList.remove("d-none")

        let nombre_cliente=(customCheck.checked===true)?nombreCliente.value:buscarCliente.value;
        if(nombre_cliente.toString().trim()=='') nombre_cliente='No seleccionado'

        areaClienteMinimizado.innerHTML=`
            <p class='mb-0'>
            <span class='mr-1'><strong>Cliente:</strong> ${nombre_cliente}</span>
            <span class="badge badge-secondary mr-1">Pago: ${(condicion.value=='1')?'Contado':'Crédito'}</span>
            <span class="badge badge-primary">Validez: ${validez.value} días</span>
            </p>
        `
    }  
}

function precio(e, id) {
    const url = base_url + 'cotizaciones/precio/' + id + '/' + e.target.value;

    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            if (res.icono != 'success') {
                alertas(res.msg, res.icono);
            }
            cargarDetalle();
            return;
        }
    }
}

function cantidad(e, id) {
    const url = base_url + 'cotizaciones/cantidad/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            if (res.icono != 'success') {
                alertas(res.msg, res.icono);
            }
            cargarDetalle();
            return;
        }
    }
}

function descuento(e, id) {
    const url = base_url + 'cotizaciones/descuento/' + id + '/' + e.target.value;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
            return false;
        }
    }
}

function clienteCustom(logic)
{
    buscarCliente.value='';
    nombreCliente.value='';

    if(logic===true)
    {
        id_cliente.value=0;
        buscarClienteContainer.classList.add("d-none");
        ClienteContainer.classList.remove("d-none");
    } else {
        id_cliente.value=1;
        buscarClienteContainer.classList.remove("d-none");
        ClienteContainer.classList.add("d-none");        
    }
}

function imprimirCotizacion() {
    /*console.log(customCheck.checked)
    console.log(`Nombre Cliente ${nombreCliente.value}`)
    console.log(`Buscar Cliente ${buscarCliente.value}`)
    console.log(`IDCliente ${id_cliente.value}`)*/

    Swal.fire({
        title: 'Cotizar los productos?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            let fila = document.querySelectorAll("#t_ventas_hist tr").length;
            if (fila < 1) {
                alertas('No hay productos para proceder con la cotizacion', 'warning');
                return false;
            } else {
                if (validez.value == '' || condicion.value == '' || nota.value == '' || id_cliente.value == '') {
                    alertas('Todo los campos con * son obligatorios', 'warning');
                    return false;
                } else {
                    const data = new FormData();
                    data.append('validez', validez.value);
                    data.append('condicion', condicion.value);
                    data.append('nota', nota.value);
                    data.append('id_cliente', id_cliente.value);
                    data.append('id_vendedor', vendedores.value);
                    data.append('fecha', fecha.value);

                    if(customCheck.checked===true) {
                        data.append('nombre_cliente', nombreCliente.value);
                    } else {
                        data.append('nombre_cliente', '');
                    }

                    const url = base_url + "cotizaciones/generar";
                    const http = new XMLHttpRequest();
                    http.open("POST", url, true);
                    http.send(data);
                    http.onreadystatechange = function () {
                        if (this.readyState == 4 && this.status == 200) {
                            const res = JSON.parse(this.responseText);
                            alertas(res.msg, res.icono);
                            if (res.folio) {
                                const ruta = base_url + 'cotizaciones/generarPdf/' + res.folio;
                                window.open(ruta)
                                setTimeout(() => {
                                    window.location.reload();                                    
                                }, 1000);
                            }
                        }
                    }
                }
            }

        }
    })
}

function cargarDetalle() {
    const url = base_url + 'cotizaciones/listar';
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            let html = '';
            res.detalle.forEach(row => {
               html += `
               <tr>
                    <td style='border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:155px;'>
                        <img src="https://ad.sismosoluciones.com/Assets/img/pro/${row['foto']}" style='width:125px;border:1px solid #eee;border-radius: 5px;'>
                    </td>
                    <td style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                        <h4 class='text-primary' style='font-weight:bold;'>${row['descripcion']}</h4>    
                        
                        <h3 class='text-dark' style='font-weight:bold;'>Q.${row['sub_total']}</h3>

                    </td>
                    <td style='text-align:left;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;'>
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>CANTIDAD</small>
                        <input type="number" class="form-control" min="1" value="${row['cantidad']}" onchange="cantidad(event, ${row['id']})">
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>DESCUENTO</small>
                        <input type="number" class="form-control" step="0.01" min="0.01" value="${row['descuento']}" onchange="descuento(event, ${row['id']})">
                    </td>

                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:10px;padding-bottom:10px;width:100px;'>
                        <small class='text-muted' style='font-size:10px;'>PRECIO</small>
                        <input type="number" class="form-control" step="1.00" min="0.00" value="${row['precio']}" onchange="precio(event, ${row['id']})">
                    </td>
                    <td style='text-align:center;vertical-align:top;border-top:1px solid #eee;padding-top:34px;padding-bottom:10px;width:60px;'>
                        <button class="btn btn-danger" type="button" onclick="eliminar(${row['id']})"><i class="fas fa-trash-alt"></i></button>                    
                    </td>

               </tr>`;               

            });
            document.getElementById("tbody_cotizacion").innerHTML = html;
            document.getElementById("total").value = res.total_pagar.total;

            let selectedOptionVendedores = vendedores.value;
            vendedores.innerHTML = '';          
            res.vendedores.forEach(row => {
                option = document.createElement('option');
                option.value = row['codven'];
                option.text = `[${row['codven']}] ${row['nombre']}`;
                vendedores.appendChild(option);
            });

            if(selectedOptionVendedores!='') vendedores.value=selectedOptionVendedores;
            
        }
    }
}

function eliminar(id) {
    const url = base_url + "cotizaciones/delete/" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            alertas(res.msg, res.icono);
            cargarDetalle();
        }
    }
}

function ingresarCotizacion(id_pro) {
    const url = base_url + 'cotizaciones/agregarProducto/' + id_pro;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            cargarDetalle();
            document.getElementById('buscarProducto').value = '';
            document.getElementById('buscarProducto').focus();
            alertas(res.msg, res.icono);
            return false;
        }
    }
}