<?php
class Crm extends Controller
{
    private $id_usuario;
    public function __construct()
    {
        session_start();
        if (empty($_SESSION['activo'])) {
            header("location: " . base_url);
        }
        parent::__construct();
        $this->id_usuario = $_SESSION['id_usuario'];
    }

    public function index()
    {
        //$data['usuarios'] = $this->model->getData('usuarios');
        //$data['clientes'] = $this->model->getData('clientes');
        //$data['productos'] = $this->model->getData('productos');
        //$data['proveedor'] = $this->model->getData('proveedor');
        //$data['marcas'] = $this->model->getData('marcas');
        //$data['categorias'] = $this->model->getData('categorias');
        //$data['ventas'] = $this->model->ventasCompras('ventas', $this->id_usuario);
        //$data['compras'] = $this->model->ventasCompras('compras', $this->id_usuario);
        //$data['empresa'] = $this->model->getEmpresa();
        $data['sucursales']=$this->model->getSucursales();
        $data['vendedores']=$this->model->getVendedores();        
        $data['operadores']=$this->model->getOperadores();

        $data['scripts'] = array(
            array('script' => 'moment.min.js'),         
            array('script' => 'chart.min.js'),
            array('script' => 'pages/crmhome.js')
        );
        $this->views->getView('crm', 'home', $data);
    }

    public function inicio()
    {
        //$data['usuarios'] = $this->model->getData('usuarios');
        //$data['clientes'] = $this->model->getData('clientes');
        //$data['productos'] = $this->model->getData('productos');
        //$data['proveedor'] = $this->model->getData('proveedor');
        //$data['marcas'] = $this->model->getData('marcas');
        //$data['categorias'] = $this->model->getData('categorias');
        //$data['ventas'] = $this->model->ventasCompras('ventas', $this->id_usuario);
        //$data['compras'] = $this->model->ventasCompras('compras', $this->id_usuario);
        //$data['empresa'] = $this->model->getEmpresa();
        $data['vendedores'] = $this->model->getVendedores();
        $data['scripts'] = array(
            array('script' => 'chart.min.js'),
            array('script' => 'pages/crmhome.js')
        );
        $this->views->getView('crm', 'home', $data);
    }



    public function getActividad($fecha)
    {
        list($fecha_desde, $fecha_hasta) = explode(',', $fecha);
        $actividad = $this->model->getActividad($fecha_desde, $fecha_hasta);
        $data=[];

        foreach($actividad as $key => $value) {
            //$value['nombre']=iso8859_1_to_utf8($value['nombre']);
            $data[$value["codven"]][]= $value;
        }

        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function datos()
    {
        $data['empresa'] = $this->model->getEmpresa();
        //$data['vendedor'] = $this->model->getVendedores();
        $data['scripts'] = array(
            array('script' => 'pages/admin.js')
        );
        $this->views->getView('admin', 'admin', $data);
    }

    public function cambiarEmpresa()
    {
        $identidad = strClean($_POST['identidad']);
        $nombre = strClean($_POST['nombre']);
        $telefono = strClean($_POST['telefono']);
        $direccion = strClean($_POST['direccion']);
        $mensaje = strClean($_POST['mensaje']);
        $impuesto = strClean($_POST['impuesto']);
        $correo = strClean($_POST['correo']);
        $smtp = strClean($_POST['smtp']);
        $clave_smtp = strClean($_POST['clave_smtp']);
        $usuario_smtp = strClean($_POST['usuario_smtp']);
        $puerto_smtp = strClean($_POST['puerto_smtp']);
        $id = strClean($_POST['id']);
        if (
            empty($identidad) || empty($nombre) || empty($telefono) || empty($direccion)
            || empty($smtp) || empty($clave_smtp) || empty($correo) || empty($usuario_smtp) || empty($puerto_smtp)
        ) {
            $msg = array('msg' => 'Todo los campos con * son requeridos', 'icono' => 'warning');
        } else {
            $img = $_FILES['imagen'];
            $name = $img['name'];
            $tmpname = $img['tmp_name'];
            $imgNombre = 'logo.png';
            $destino = "Assets/img/" . $imgNombre;
            $data = $this->model->modificarDatos($identidad, $nombre, $telefono, $correo, $direccion, $mensaje, $impuesto, $smtp, $usuario_smtp, $clave_smtp, $puerto_smtp, $id);
            if ($data == 'ok') {
                if (!empty($name)) {
                    move_uploaded_file($tmpname, $destino);
                }
                $msg = array('msg' => 'Datos actualizado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al actualizar', 'icono' => 'error');
            }
        }

        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }

    public function verVisita($id)
    {
        $data = $this->model->getVisita($id);
        echo json_encode($data);
    }

    public function stock_minimo()
    {
        $data = $this->model->selectStockM();
        echo json_encode($data);
    }

    public function productos()
    {
        $data = $this->model->selectProductos();
        echo json_encode($data);
    }

    public function comparacionComprasVentasMes($anio)
    {
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresos('ventas', $desde, $hasta, $id_user);
        $data['compras'] = $this->model->ingresos('compras', $desde, $hasta, $id_user);
        echo json_encode($data);
        die();
    }

    public function comparacionVentasVendedor($datos)
    {
        list($anio,$sucursal)=explode(',',$datos);
        list($desde,$hasta)=explode('_',$anio);
        //var_dump($anio,$sucursal);
        /*$desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';*/
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresosVendedor('ventas', $desde, $hasta, $sucursal);
        
        echo json_encode($data);
        die();
    }
    

    public function comparacionVentasMes($anio)
    {
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresos('ventas', $desde, $hasta, $id_user);
        echo json_encode($data);
        die();
    }
    public function comparacionVentasSucursalAno($anio)
    {
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data=$this->model->ingresosSucursal('ventas', $desde, $hasta, 1);
        echo json_encode($data);
        die();
    }
    
    public function comparacionVentasSucursalMensual($anio)
    {
        list($desde,$hasta)=explode('_',$anio);
        //$desde = $anio . '-01-01';
        //$hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data=$this->model->ingresosSucursalMes('ventas', $desde, $hasta, 1);
        echo json_encode($data);
        die();
    }

    public function actualizarGrafico($anio)
    {
        $desde = $anio . '-01-01';
        $hasta = $anio . '-12-31';
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresos('ventas', $desde, $hasta, $id_user);
        $data['compras'] = $this->model->ingresos('compras', $desde, $hasta, $id_user);
        echo json_encode($data);
        die();
    }

    public function actualizarGraficoDia($dia)
    {
        $id_user = $this->id_usuario;
        $data['ventas'] = $this->model->ingresosDia('ventas', $dia, $id_user);
        $data['compras'] = $this->model->ingresosDia('compras', $dia, $id_user);
        echo json_encode($data);
        die();
    }

    public function permisos()
    {
        $this->views->getView('admin', 'permisos');
    }

    public function tipoReporte($nombre)
    {
        if ($nombre == 'ticket') {
            $_SESSION['ticket'] = true;
        }else{
            $_SESSION['ticket'] = false;
        }
        $msg = array('msg' => 'Tipo de reporte cambiado', 'icono' => 'success');
        echo json_encode($msg, JSON_UNESCAPED_UNICODE);
        die();
    }
}

function iso8859_1_to_utf8(string $s): string {
    $s .= $s;
    $len = \strlen($s);

    for ($i = $len >> 1, $j = 0; $i < $len; ++$i, ++$j) {
        switch (true) {
            case $s[$i] < "\x80": $s[$j] = $s[$i]; break;
            case $s[$i] < "\xC0": $s[$j] = "\xC2"; $s[++$j] = $s[$i]; break;
            default: $s[$j] = "\xC3"; $s[++$j] = \chr(\ord($s[$i]) - 64); break;
        }
    }

    return substr($s, 0, $j);
}