<?php
class CreditocomprasModel extends Query
{
    public function __construct()
    {
        parent::__construct();
    }
    public function getEmpresa()
    {
        $sql = "SELECT * FROM empresa";
        $data = $this->select($sql);
        return $data;
    }
    public function actualizarCredito(string $table,string $monto, string $restante, int $id)
    {
        $sql = "UPDATE $table SET abonado = ?, restante = ? WHERE id = ?";
        $datos = array($monto, $restante,$id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    public function estado(string $table,int $estado, int $id)
    {
        $sql = "UPDATE $table SET estado = ? WHERE id = ?";
        $datos = array($estado, $id);
        $data = $this->save($sql, $datos);
        if ($data == 1) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    //compras
    public function getCreditos(int $id_usuario)
    {
        $sql = "SELECT p.nombre, cr.*, c.estado AS estatus FROM proveedor p INNER JOIN creditos_compras cr ON p.id = cr.proveedor INNER JOIN compras c ON cr.compra = c.id WHERE cr.id_usuario = $id_usuario";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function getAbono(int $id)
    {
        $sql = "SELECT p.id AS id_proveedor, p.nombre, cr.* FROM proveedor p INNER JOIN creditos_compras cr ON p.id = cr.proveedor WHERE cr.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function registrarAbono(int $id_credito, int $id_proveedor, string $monto, string $fecha, string $hora, int $id_usuario)
    {
        $sql = "INSERT INTO abonos_compras(id_credito, id_proveedor,monto, fecha, hora, id_usuario) VALUES (?,?,?,?,?,?)";
        $datos = array($id_credito, $id_proveedor, $monto, $fecha, $hora, $id_usuario);
        $data = $this->insertar($sql, $datos);
        return $data;
    }
    public function detalleCredito(int $id)
    {
        $sql = "SELECT c.*, d.*, p.id AS id_pro, p.descripcion FROM creditos_compras c INNER JOIN detalle_compra d ON d.folio = c.compra INNER JOIN productos p ON d.id_producto = p.id WHERE c.id = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function detalleAbono(int $id)
    {
        $sql = "SELECT a.monto AS abono, a.fecha, c.*, pr.nombre FROM abonos_compras a INNER JOIN creditos_compras c ON a.id_credito = c.id INNER JOIN proveedor pr ON a.id_proveedor = pr.id WHERE a.id_credito = $id";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function detalleProveedor(int $id)
    {
        $sql = "SELECT c.*, pr.nombre, pr.telefono, pr.direccion, co.estado AS estatus FROM creditos_compras c INNER JOIN proveedor pr ON c.proveedor = pr.id INNER JOIN compras co ON c.compra = co.id WHERE c.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function datoAbono(int $id)
    {
        $sql = "SELECT p.nombre,p.telefono, p.direccion, a.*, cr.id, cr.monto AS total, cr.abonado, cr.restante FROM proveedor p INNER JOIN abonos_compras a ON p.id = a.id_proveedor INNER JOIN creditos_compras cr ON cr.id = a.id_credito WHERE a.id = $id";
        $data = $this->select($sql);
        return $data;
    }
    public function getAbonos(int $id_usuario)
    {
        $sql = "SELECT p.nombre, a.* FROM proveedor p INNER JOIN abonos_compras a ON p.id = a.id_proveedor WHERE a.id_usuario = $id_usuario";
        $data = $this->selectAll($sql);
        return $data;
    }
    public function estadoCompra(int $id)
    {
        $sql = "SELECT cr.compra FROM compras c INNER JOIN creditos_compras cr ON c.id = cr.compra WHERE cr.id = $id";
        $data = $this->select($sql);
        return $data;
    }
}
